// Copyright 1995 Barbara Liskov

/*
\section{OR Configuration Information}

This module groups together various configuration parameters into one
structure.  The module will have to be extended as more configuration
parameters become necessary.
*/

#ifndef _OR_CONFIG_H
#define _OR_CONFIG_H

#include "common/basic.h"
#include "common/bits.h"
#include "common/or_num.h"


// Information supplied at OR initialization time.
class OR_init_config;

class OR_config {
  public:
    // Port number for server socket that listens to FEs
    int fe_socket;
    // Port number for server socket that listens to ORs
    int or_socket;

    // Port offset of this OR; added to default ports to listen for FEs and ORs
    int port_offset;

    OR_num ornum;  // OR number. Has to be initialized.

    // OR backing store.
    char const* disk;

    // Cache size (in bytes)
    int cache_size;

    // Log size (in bytes)
    int log_size;

    // Log application should start when this percent of log is full
    int apply_threshold;

    // Log cleaning should try to clean enough of the log to make it
    // this percent full.
    int target_percent;

    // Printing debug information. Higher number means more information
    int debug_level;

    // Initialization information.  Null if not initializing
    OR_init_config* init;
};

#define OR_CONFIG_DEFAULT_FILE		"sample.or"
#define OR_DEFAULT_CACHE_SIZE		(4*1024*1024)
#define OR_DEFAULT_LOG_SIZE		(6*1024*1024)
#define OR_DEFAULT_APPLY_PERCENT	90
#define OR_DEFAULT_TARGET_PERCENT	80

class OR_init_config {
  public:
    // Name of the file used to generate the initial database.
    // If 0 use the default initialization string.
    char const* input_file;

    // Size of the disk in disk blocks.
    int size;

    // Preferred segment size in disk blocks.
    int segsize;
};

#endif /* _OR_CONFIG_H */
