
#ifndef _PREF_SET_T
#define _PREF_SET_T 1

#include "common/map.h"
#include "common/bhash.t"
#include "common/buckets.t"
#include "common/th_assert.h"


// Class that maps segment ids to bitmaps representing which objects
// in a segment were recently sent to an FE.

struct Bitmap {
   int *bitmap;
   int size;

   Bitmap(int sz) { 
      size = sz/(sizeof(int)*8)+!!(sz%(sizeof(int)*8));
      bitmap = new int[size];
      for (int i = 0; i < size; i++)
	bitmap[i] = 0;
   }

   ~Bitmap(void) {delete bitmap;}

    inline void insert(int index) {
        th_assert(sizeof(int)*8 == 32, "Size of int != 32\n");
        int div = index >> 5;
        th_assert(div <= size, "Out of bounds\n");
        int mod = index - (div << 5);
        bitmap[div] |= ( 1 << mod);
    }
  
    inline bool contains(int index) {
	th_assert(sizeof(int)*8 == 32, "Size of int != 32\n");
        int div = index >> 5;
	if (div > size)
	   return FALSE;
        int mod = index - (div << 5);
        return (bitmap[div] >> mod) & 1;
    }

};
   

   
class Pref_set  : public Map<IntKey, Bitmap* > {
public:
   Pref_set(int sz) : Map<IntKey, Bitmap* >(sz) {}
   ~Pref_set() { clear();}

   void clear(void) {
       HashGenerator<IntKey, Bitmap*> *g = mappings();
       IntKey k;
       while (g->get(k)) { 
          delete g->value();
          g->remove();
       }
   }
   
   void insert_oref(int oref) {
	int segnum = OREF_SEGMENT(oref);
        int index = OREF_INDEX(oref);
        Bitmap *b;
        if (!find(segnum, b)) {
            b = new Bitmap(1024); //XXXXX find size of segment in objects
            store(segnum, b);
        }
        b->insert(index);
   }


   int contains_oref(int oref) {
        int segnum = OREF_SEGMENT(oref);
        int index = OREF_INDEX(oref);
        Bitmap *b;
        if (find(segnum, b)) {
            return b->contains(index);
        } else
            return FALSE;
   }
};

#endif



















