// Copyright 1995 Barbara Liskov

/*
\section{Read-Write Lock Implementation: Concurrent and fifo}

The implementation uses 2 mutexes and 1 condition variable.  The idea is
like RW_lock_unfair, but an additional mutex (m2) is used to queue up
readers and writers. The fairness provided by this impl relies on fairness
in granting mutexes to threads. (For the pthread/OSF1 impl, mutexes are
granted in the order of thread priority, and in FIFO order among threads
with equal priority.)

XXX This algorithm is original and needs to be proven correct (if it is).
*/

#include "thread.h"
#include "rwlock.h"
#include "rwlock_fifo.h"


RW_lock_fifo::RW_lock_fifo() {
    readers = 0;
    m = new Mutex;
    m2 = new Mutex;
    c = new Condition(m);
}

RW_lock_fifo::~RW_lock_fifo() {
    delete m;
    delete m2;
    delete c; // is this the recommended order?
}

void RW_lock_fifo::read_lock() {
    m2->grab();
    m->grab();
    readers++;
    m->release();
    m2->release();
}

void RW_lock_fifo::read_unlock() {
    m->grab();
    readers--;
    if (readers == 0) c->signal();
    m->release();
}

void RW_lock_fifo::write_lock() {
    m2->grab();
    m->grab();
    while (readers > 0) c->wait();
    m->release();
}

void RW_lock_fifo::write_unlock() {
    m2->release();
}
