// Copyright 1995 Barbara Liskov

#include <stdio.h>
#include <stdlib.h>

#include "common/or_obj.h"
#include "common/prefetch.h"
#include "server.h"

static void dump_object(char const* name, OR_obj* obj);

main(int argc, char** argv) {
    Server* server = new Server(getenv("THOR"));
    
    Oref oref;
    if (argc == 3) {
	OREF_SET(oref,atoi(argv[1]),atoi(argv[2]));
    }
    else {
	oref = server->root();
    }
    printf("oref = <%d,%d>\n", OREF_SEGMENT(oref), OREF_INDEX(oref));

    prefetch_hint h;
    h.max_prefetch = 0;

    OR_obj* obj = server->fetch_one(oref, &h);
    dump_object("object contents", obj);
    delete [] ((OR_slot*) obj);
    return 0;
}

static void dump_object(char const* name, OR_obj* obj) {
    if (obj == 0) {
	printf("%s = nil\n", name);
	return;
    }

    printf("%s =\n", name);

    char const* formatv1 = "  %-15s = %12d\n";
    char const* formatv2 = "  %-15s = <%d,%d>\n";

    printf(formatv1, "class",   OR_OBJ_CLASS(obj));
    //printf(formatv1, "uid",	OR_OBJ_UID(obj));
    printf(formatv1, "size",	OR_OBJ_SIZE(obj));
    printf(formatv1, "bfield",	OR_OBJ_BITFIELD(obj));
    printf("  ====\n");

    Obj_bitfield bf = OR_OBJ_BITFIELD(obj);
    for (int i = 0; i < OR_OBJ_SIZE(obj); i++) {
	if ((bf == OBJ_BF_ALLREFS) ||
	    (!OBJ_BF_SPECIAL(bf) && OBJ_BF_ISREF(bf,i))) {
	    printf(formatv2, "oref",
		   OREF_SEGMENT(obj->slot[i].xref.oref),
		   OREF_INDEX(obj->slot[i].xref.oref));
	}
	else {
	    printf(formatv2, "data",
		   obj->slot[i].value32[0],
		   obj->slot[i].value32[1]);
	}
    }
}
