// Copyright 1995 Barbara Liskov

// \section{Pthread-based Thread Implementation}

#include <errno.h>
#include <pthread.h>

#include "common/fail.h"
#include "thread.h"

// Wrapper for thread creation.
static void* thread_wrapper(pthread_addr_t);

Thread::Thread() {
}

Thread::~Thread() {
}

void Thread::start() {
    pthread_t pt;

    // Try creating thread several times to deal with "EAGAIN"
    int count = 0;
    while (count < 5) {
	if (pthread_create(&pt, pthread_attr_default, thread_wrapper,
			   (pthread_addr_t) this) == 0)
	    break;
	if (errno != EAGAIN) sysfail("pthread_create");
	count++;
    }

    if (pthread_detach(&pt) != 0) {
	sysfail("pthread_detach");
    }
}

static void* thread_wrapper(pthread_addr_t arg) {
    Thread* thread = (Thread*) arg;

    thread->main();
    delete thread;
    return 0;
}

struct Mutex_Rep {
    pthread_mutex_t mutex;
};

Mutex::Mutex() {
    rep = new Mutex_Rep;
    if (pthread_mutex_init(&(rep->mutex), pthread_mutexattr_default) != 0) {
	sysfail("pthread_mutex_init");
    }
}

Mutex::~Mutex() {
    if (pthread_mutex_destroy(&(rep->mutex)) != 0) {
	sysfail("pthread_mutex_destroy");
    }
    delete rep;
}

void Mutex::grab() {
    if (pthread_mutex_lock(&(rep->mutex)) != 0) {
	sysfail("pthread_mutex_lock");
    }
}

void Mutex::release() {
    if (pthread_mutex_unlock(&(rep->mutex)) != 0) {
	sysfail("pthread_mutex_unlock");
    }
}

struct Condition_Rep {
    pthread_cond_t   cond;
    pthread_mutex_t* mutex;
};

Condition::Condition(Mutex* mutex) {
    rep = new Condition_Rep;
    if (pthread_cond_init(&(rep->cond), pthread_condattr_default) != 0) {
	sysfail("pthread_cond_init");
    }
    rep->mutex = &(mutex->rep->mutex);
}

Condition::~Condition() {
    if (pthread_cond_destroy(&(rep->cond)) != 0) {
	sysfail("pthread_cond_destroy");
    }
    delete rep;
}

void Condition::wait() {
    if (pthread_cond_wait(&(rep->cond), rep->mutex) != 0) {
	sysfail("pthread_cond_wait");
    }
}

void Condition::signal() {
    if (pthread_cond_signal(&(rep->cond)) != 0) {
	sysfail("pthread_cond_signal");
    }
}

void Condition::broadcast() {
    if (pthread_cond_broadcast(&(rep->cond)) != 0) {
	sysfail("pthread_cond_broadcast");
    }
}
