// Copyright 1995 Barbara Liskov

/*
\section{Update Thread Implementation}
 
XXX Possible race condition when two update threads run simultaneously:
can one truncate the VQ before the other has added objects to invalid sets?

*/

#include "common/or_index.h"
#include "common/fail.h"
#include "common/oref_set.h"

#include "thread.h"
#include "update.h"
#include "fe_manager.h"
#include "or.h"
#include "or_config.h"
#include "tstatus.h"
#include "or_or_msg.h"
#include "tm.h"
#include "vqueue.h"

#include "mm/log.h"
#include "mm/logrecord.h"

Installer::Installer(Tid const& tid, Xrefs *xrefs, Uids *uids, 
		     OR_Index *index, Log_Index pl) {
    xrefs_ = xrefs;
    uids_  = uids;
    index_ = index;
    tid_   = tid;
    pl_    = pl;
}

Installer::~Installer() {
    // xrefs & uids are deleted by tstatus.
    // index is deleted by committed log record.
}

void Installer::main() {
    // Find transaction's prepare record
    Data_Log_Record *dr = (Data_Log_Record *) or->log->fetch(pl_);    
    th_assert(dr != 0, "Missing prepare record for committed transaction");

    // Find FE manager of client that committed transaction
    fe_num fe;
    FE_manager *mgr = NULL;
	
    if (or->tstatus->get_fe(tid_, fe)) {
	// See if FE is still connected
	or->fe_info_set->lock->read_lock();
	mgr = or->fe_info_set->get_manager(fe);
	or->fe_info_set->lock->read_unlock();
    }

    // Put new objects in FE table BEFORE installing transaction.
    // Other clients can fetch the objects and modify them after the
    // install, so the objects must already be in FE table.
    or->tm->add_to_FE_table(mgr, xrefs_);

    // Install prepare record
    dr->commit(xrefs_, index_);
    dr->install();
    
    // XXX Bug - FE can hang up between manager lookup and use in
    // add_to_invalid_sets.  

    // Add to invalid sets of FEs. This is
    // conservative since the objects have been installed and an FE may
    // have fetched the new version and still its version may be
    // invalidated
  
    int wsize;
    const Oref* wset = or->tm->vq->get_write_set(&tid_, wsize);
    or->tm->add_to_invalid_sets(mgr, wset, wsize);
    // Mark the transaction as installed
    or->tm->mark_installed(&tid_);
    or->log->installed(pl_);

    // Tell tstatus that we're done with transaction
    or->tstatus->installed(tid_);

    or->tm->truncate_vqueue_if_needed();

    if (or->config->debug_level > 1)
	printf("Update thread done installing transaction results\n");
}

void start_update(Log_Index prepare_index, or_or_message *msg) {
    // XXX For now, just keep creating installer objects.
    //     Should delete them when thread ends.
    th_assert(msg->msgtype == OR_COMMIT, "Bad message type passed to update thread");
    Installer *inst = new Installer(msg->tid, msg->u.commit.xrefs, 
				    msg->u.commit.uids, msg->u.commit.index,
				    prepare_index);
    inst->start();
}
