// Copyright 1995 Barbara Liskov

/*
\section{Update Phase Thread}

This file describes the thread that performs phase 2 of the two-phase commit.
The thread is created by the TM and installs the result of the transaction
in the background.
*/

#ifndef _UPDATE_H
#define _UPDATE_H

#include "common/tid.h"
#include "mm/logindex.h"

class Thread;
class OR_Index;
class or_or_message;
class Xrefs;
class Uids;

class Installer : public Thread {
public:
    Installer(Tid const& tid, Xrefs *xrefs, Uids *uids, 
	      OR_Index *index, Log_Index pl);
    // requires - xrefs & uids are new objects of given transaction; index
    //            gives offset into xrefs for participant ORs.
    // effects  - Create installation thread to perform phase 2.  The thread
    //            is inactive and must be started by a call to "start()".

    ~Installer();
    // effects  - deletes ORIndex that was passed to constructor.

    void main();

private:
    Xrefs *xrefs_;    // All the information we need to install transaction.
    Uids  *uids_;
    OR_Index *index_;
    Tid tid_;
    Log_Index pl_;     // Index of transaction's prepare record
};

void start_update(Log_Index index, or_or_message *msg);
// requires - msg is commit message sent to a participant.
//            index is log index of transaction's prepare record.
// effects  - Create and start update phase thread for given transaction.

#endif /* _UPDATE_H */
