# Directory-tests specific code

send_user "\nDirectory Tests Started\n"

proc check_size {sz ok_msg err_msg} {
    # effects: Checks that directory has sz elements. If it has
    #          it outputs ok_msg. Otherwise it outputs err_msg.
    global CLIENT_ID num_regexp

    send -i $CLIENT_ID "s\n"
    
    expect {
	-i $CLIENT_ID -re "Directory size: *$num_regexp" {
	    if {$expect_out(1,string) == $sz} {
		send_user $ok_msg
	    } else {
		send_user $err_msg
	    }
	}
	-i $CLIENT_ID timeout {
	    send_user $err_msg
            exit 1
	}
    }
}




proc check_insertions {ninserts} {
    # requires: Directory in dirTest is initially empty
    #
    # effects: Inserts ninserts objects of each type in {string, int, char, 
    #          bool, null} in the directory and checks the final directory 
    #          size.
    global CLIENT_ID

    for {set i 1} {$i <= $ninserts} {incr i} {
	# Insert strings
	send -i $CLIENT_ID "i\nstr$i\nstr$i\n"

	# Insert ints
	send -i $CLIENT_ID "i\nint$i\n$i\n"

        # Insert chars
	send -i $CLIENT_ID "i\nchar$i\na\n"

	# Insert bools
	send -i $CLIENT_ID "i\nbool$i\ntrue\n"

	# Insert nulls
	send -i $CLIENT_ID "\inull$i\nnull\n"
    }

    # Check that directory has 5*ninserts elements
    check_size [expr 5*$ninserts] "Test: Insertion of [expr 5*$ninserts]\
    objects... ok\n" "Error: Insertion test failed\n"        
}  


proc check_list {ninserts msg} {
    # requires: Directory contains only the objects inserted by 
    #           check_insertions
    #
    # effects: Checks if the objects in check_insertions are in the directory
    global CLIENT_ID till_eol

    send -i $CLIENT_ID "l\n"

    for {set i 1} {$i <= $ninserts} {incr i} {
	expect {
	    -i $CLIENT_ID -re "str$i *str$i" {}
	    -i $CLIENT_ID timeout {
		send_user "Error: Lookup of inserted string failed\n"
		exit 1
	    }
	}
	expect {
	    -i $CLIENT_ID -re "int$i  Int  $i" {}
	    -i $CLIENT_ID timeout {
		send_user "Error: Lookup of inserted int failed\n"
		exit 1
	    }
	}
	expect {
	    -i $CLIENT_ID -re "char$i  Char a" {}
	    -i $CLIENT_ID timeout {
		send_user "Error: Lookup of inserted char failed\n"
		exit 1
	    }
	}
	expect {
	    -i $CLIENT_ID -re "bool$i  Bool T" {}
	    -i $CLIENT_ID timeout {
		send_user "Error: Lookup of inserted bool failed\n"
		exit 1
	    }
	}
	expect {
	    -i $CLIENT_ID -re "null$i  null" {}
	    -i $CLIENT_ID timeout {
		send_user "Error: Lookup of inserted null failed\n"
		exit 1
	    }
	}
    }
    
    send_user $msg
    
}  


# ---------------------------------------------------------------------------
#                              TESTS START HERE 
# ---------------------------------------------------------------------------

# Start OR and a client
set OR_ID [spawn_or dirTest_db 1 0 ""]

spawn_client $OR_ID FE_ID CLIENT_ID FE_NAME dirTest "-D1 -m 1 -s 1700 -i" ""

# Check that directory is initially empty
check_size 0 "Test: Root directory initially empty ... ok\n" \
 "Error: Root directory is not initially empty\n"

#Check local directory is initially empty
send -i $CLIENT_ID "x\n"
check_size 0 "Test: Local directory initially empty (1)... ok\n" \
 "Error: Local directory is not initially empty\n"

# Check insertion of ninserts objects in local directory
set ninserts 10
check_insertions $ninserts

# Check exception on insertion of an existing name
send -i $CLIENT_ID "i\n str1\n str1\n"
expect {
    -i $CLIENT_ID -re "was already in the directory" {
	send_user \
	    "Test: Exception on insertion of an existing name ... ok\n"
    }
    -i $CLIENT_ID timeout {
	send_user "Error: Insert exception test failed\n"
        exit 1
    }
}


# Check lookups with generator
check_list $ninserts "Test: Lookups and generator ... ok\n"


# Check exception on lookup of non-existing object
send -i $CLIENT_ID "o\nnon-ext\n"
expect {
    -i $CLIENT_ID -re "No object named" {
	send_user \
	    "Test: Exception on lookup of non-existing object ... ok\n"
    }
    -i $CLIENT_ID timeout {
	send_user "Error: Lookup exception test failed\n"
    }
}

# Insert local directory in root directory to make it persistent
send -i $CLIENT_ID "z\n"

# Commit changes
send -i $CLIENT_ID "c\n"
expect {
    -i $CLIENT_ID -re "Transaction Committed" {}    
    -i $CLIENT_ID timeout {
	send_user "Error: Unable to commit transaction\n"
    }
}



# Check persistency
close_process $CLIENT_ID
close_process $FE_ID
close_process $OR_ID

set OR_ID [spawn_or dirTest_db 0 0 ""]
spawn_client $OR_ID FE_ID CLIENT_ID FE_NAME dirTest "-D1 -m 1 -s 1700 -i" ""

#Check local directory is initially empty
send -i $CLIENT_ID "x\n"
check_size 0 "Test: Local directory initially empty (2)... ok\n" \
 "Error: Local directory is not initially empty\n"
send -i $CLIENT_ID "y\n"

# Lookup old local dir in root dir
send -i $CLIENT_ID "w\n"

# Check if contents of old local dir were made persistent
check_list $ninserts "Test: Persistence ... ok\n"

# Check remove
send -i $CLIENT_ID "r\nstr1\n"
send -i $CLIENT_ID "o\nnstr1\n"
expect {
    -i $CLIENT_ID -re "No object named" {
	send_user \
	    "Test: Remove ... ok\n"
    }
    -i $CLIENT_ID timeout {
	send_user "Error: Remove test failed\n"
        exit
    }
}


# Check remove exception
send -i $CLIENT_ID "r\nstr1\n"
expect {
    -i $CLIENT_ID -re "No object named" {
	send_user \
	    "Test: Exception on removal of non-existing object ... ok\n"
    }
    -i $CLIENT_ID timeout {
	send_user "Error: Remove exception test failed\n"
        exit
    }
}


close_process $CLIENT_ID
close_process $FE_ID
close_process $OR_ID






