# OO7-specific code
set timeout 10
send_user "\nOO7 Tests Started (5 minutes)\n"

# Start OR and a client.
set OR_ID [spawn_or small_db 1 0 ""]
spawn_client $OR_ID FE_ID CLIENT_ID FE_NAME oo7 "-D1 -s 8000" ""

# Create small database name it s in directory.
send -i $CLIENT_ID "s\n s\n"

send_user "Test: Creation of small database ..."

# Wait for last transaction in database creation and check it has the 
# right attributes. Check client knows that the transaction commited
set read 24
set new 252
set mod 35
while 1 {
    expect {
	-i $OR_ID -re "Transaction 493 Committed" {
	    assert_commit $OR_ID $FE_ID $CLIENT_ID $FE_NAME $read $mod \
		$new "Error: Creation of small database failed"
	    break
	}
	timeout {
            th_assert [is_valid_spawnid $CLIENT_ID] "Client died "
            th_assert [is_valid_spawnid $FE_ID] "FE/Client died "
            th_assert [is_valid_spawnid $OR_ID] "OR died "
	}
    }
}
send_user " ok \n"

# Run t2a  within appplication and Thor
send -i $CLIENT_ID "M\n s\n 2a\n"

send_user "Test: Traversal 2a ..."

# Wait for commit
set read_were_shrunk 0
set read 1008
set new 0
set mod 24
while 1 {
    expect {
        -i $OR_ID -re "Transaction 531 Committed" {
	    assert_commit $OR_ID $FE_ID $CLIENT_ID $FE_NAME $read $mod \
		$new "Error: Traversal 2a failed "
	    break
        }
        timeout {
            th_assert [is_valid_spawnid $CLIENT_ID] "Client died"
            th_assert [is_valid_spawnid $FE_ID] "FE/Client died"
            th_assert [is_valid_spawnid $OR_ID] "OR died"
        }
    }
}

expect {
    -i $FE_ID -re "Shrunk $num_regexp $till_eol" {
	if {$expect_out(1,string)} {incr read_were_shrunk}
    }
}

expect {
    -i $CLIENT_ID -re "Result from traversal = $num_regexp" {
	th_assert [expr $expect_out(1,string) == 2187]\
	    "\n Error: Wrong result returned by traversal\n"
	send_user " ok \n"
    }
}


send_user "Test: Committing of large no. of read/modified objects ... ok\n"

if {$read_were_shrunk} {
    send_user "Test: Shrinking of objects read by a transaction .. ok\n"
} else {
    send_user \
	"NOTE: NOT able to test shrinking of objects read by transaction\n"
}

send_user "Test: Draining OR log ..."

close_process $CLIENT_ID
close_process $FE_ID
close_process $OR_ID

send_user " ok \n"

