#ifndef _FE_MESSAGE_H
#define _FE_MESSAGE_H

#include "utils/bits.h"
#include "utils/send_message.h"
#include "utils/recv_message.h"

// This file contains messages for each type of message that is sent by an FE
// and does not use data structures that are paritucular to the FE and OR
// (If a particular message is sent by an FE and an OR, it is defined in the
//  file or_message.h)

// A message X has a class called "X_msg" and its 32 bit type is "X_type"

// Messages initiated by the FE

Ubits32 const FE_get_root_type       = 100;
Ubits32 const FE_fetch_type          = 101;
Ubits32 const FE_commit_type         = 102;
Ubits32 const FE_invalid_ack_type    = 103;
Ubits32 const FE_alloc_type          = 104;
Ubits32 const FE_debug_type          = 105;
Ubits32 const FE_change_params_type  = 106;
Ubits32 const FE_trigger_type        = 107;

Ubits32 const FE_last_allowed_msg_type = 199;
// No FE message type should be larger than this
// If you want more numbers, see or_message.h

// These are the the various debug message requests sent by the testing
// code to the OR
Ubits32 const FE_debug_seg_table   =  1; // Debug segment table
Ubits32 const FE_debug_segment     =  2; // Debug a particular segment
Ubits32 const FE_debug_page        =  3; // Debug a particular page
Ubits32 const FE_debug_object      =  4; // Debug a particular object
Ubits32 const FE_debug_fe          =  5; // Debug a particular FE
Ubits32 const FE_debug_cachedir    =  6; // Debug the cache directory
Ubits32 const FE_debug_cache       =  7; // Debug the cache
Ubits32 const FE_debug_log         =  8; // Debug the log
Ubits32 const FE_debug_itable      =  9; // Debug the installation table
Ubits32 const FE_debug_tm          = 10; // Debug the transaction manager
Ubits32 const FE_debug_config      = 11; // Print the configuration params
Ubits32 const FE_debug_root        = 12; // Print the root info

// Various message classes

class FE_change_params_msg: public Send_message, public Recv_message {
    // Overview: For changing various parameters at the OR
  public:

    bool encode(Network* net);
    bool decode(Network* net, Ubits32 msg_id);
    bool skip(Network* net);

    Define_message_type(FE_change_params_type);
  private:
    Ubits32 log_size;     // Change log size (bytes)
    Ubits32 cache_size;   // Change cache size (bytes)
    Ubits32 dspace_use;   // Change disk space utilization  (percent)
    // If any of the above variables are 0, the value is not changed
};

typedef FE_change_params_msg FE_send_change_params_msg;
typedef FE_change_params_msg FE_recv_change_params_msg;

// Various codes for FE_trigger_type message
Ubits32 const FE_trigger_gc_stats_start = 1;
Ubits32 const FE_trigger_gc_stats_print = 2;
Ubits32 const FE_trigger_or_kill = 3;
Ubits32 const FE_trigger_stats = 4;

#endif /* _FE_MESSAGE_H */
