#ifndef _OR_MESSAGE_H
#define _OR_MESSAGE_H

#include "utils/basic.h"
#include "utils/bits.h"
#include "utils/message.h"
#include "utils/recv_message.h"
#include "utils/send_message.h"
#include "oref.h"

class Network;
class OR_stat;

// This file contains messages for each type of message that is sent by an OR.
// (If a particular message is sent by an FE and an OR, it is defined in the
//  file or_message.h)

// A message X has a class called "X_msg" and its 32 bit type is "X_type"

// Messages initiated by the OR

Ubits32 const OR_root_type              = 200;
Ubits32 const OR_data_type              = 201;
Ubits32 const OR_commit_reply_type      = 202;
Ubits32 const OR_invalidation_type      = 203;
Ubits32 const OR_alloc_reply_type       = 204;
Ubits32 const OR_debug_reply_type       = 205;
Ubits32 const OR_stat_reply_type        = 206;

// No OR message type should be larger than Last_allowed_msg_type (see
// file utils/message.h)

// Commit results sent by the OR
Ubits32 const OR_committed      = 10;     // Commit succeeded
Ubits32 const OR_abort_tstamp   = 20;     // Threshold check failed
Ubits32 const OR_abort_invcheck = 30;     // Invalid object check failed
Ubits32 const OR_abort_vqcheck  = 40;     // VQ check failed
Ubits32 const OR_abort_space    = 50;     // No space available at OR
Ubits32 const OR_abort_timeout  = 60;     // Some participant timed out
Ubits32 const OR_abort_other    = 70;     // Some other reason for abort


// Various message classes

class OR_stat_reply_msg:  public Send_message, public Recv_message {
    // Overview: Reply to a FE_stat message 
  public:
    OR_stat_reply_msg(OR_stat* stat_): stat(stat_) {}
    bool encode(Network* net);
    bool decode(Network* net, Ubits32 msg_id);
    bool skip(Network* net);

    Define_message_type(OR_stat_reply_type);
    Define_synch_msg();

  private:
    OR_stat *stat;
};

typedef OR_stat_reply_msg   OR_send_stat_reply_msg;
typedef OR_stat_reply_msg   OR_recv_stat_reply_msg;

#endif /* _OR_MESSAGE_H */
