/* 
\section{Set of OR numbers}

This abstraction is used to hold a set of OR numbers, for example
the set of participants in a transaction.  
*/

#ifndef _OR_SET_H
#define _OR_SET_H

#include <stdio.h>
#include "utils/basic.h"
#include "utils/bits.h"
#include "utils/array.h"
#include "or_num.h"

class Device;

declareArray(OR_array, OR_num)

class OR_set {
public:
    OR_set();
    // effects - Creates an empty OR set

    ~OR_set();

    OR_set& operator=(OR_set const& set);
    // effects - Copies given set into *this.

    void add(OR_num or_num);
    // effects - Add or_num to set, if it's not already present.

    bool remove(OR_num or_num);
    // effects - If or_num appears in set, remove it and return TRUE.
    //           Otherwise return FALSE.

    bool member(OR_num or_num);
    // effects - Returns TRUE iff or_num is in set.

    void clear();
    // effects - Remove all elements of set

    int size();
    // effects - Returns number of elements of set.

// \subsection{Element generators}

    class Elements {
    public:
	Elements(OR_set const *s);
        // requires     s is not modified for the lifetime of generator.
        // effects      Generate each element of s.
        //              Each element is generated exactly once.
        //              Elements are generated in arbitrary order.

        bool get(OR_num& or_num);
        // modifies this, or_num.
        // effects  If more OR numbers are available, modify or_num to
        //          contain the pointer to the next or_num and
        //          return TRUE.  Else do not modify or_num,
        //          and return FALSE.
    private:
        // Generator state includes the info array, and an index into the
        // the array
        OR_array const *list;
        int index;
    };

    class SortedElements {
    public:
	SortedElements(OR_set const* s);
        // requires     s is not modified for the lifetime of generator.
	// modifies     s (sorts s)
        // effects      Generate each element of s.
        //              Each element is generated exactly once.
        //              Elements are generated in increasing order.

        bool get(OR_num& or_num);
	// see Elements::get
    private:
	OR_array const *list;
        int index;
    };

// \subsection{Device Transmission Operations}

    int  encode_size() const;
    bool encode(Device* net) const;
    bool decode(Device*);
    // effects - Empties this and then fills it with data from the
    //           network.
    
    void print(FILE *fp = NULL);
private:

//
// \subsection{Representation}
// The rep is an unsorted array (though it may be sorted by a generator).
// The invariant is that each OR_num appears at most once.

    OR_array set;
    friend Elements;
    friend SortedElements;
};

#endif /* _OR_SET_H */
