#ifndef _OR_STAT_H
#define _OR_STAT_H

// Statistics reported by OR

#include <stdio.h>
#include "utils/basic.h"
#include "utils/bits.h"

class Network;

// Time value encoded in "or_stat" message
struct or_st_time {
    Ubits32 seconds;
    Ubits32 micros;
};

extern void zero_time(or_st_time& t);
// modifies	"t"
// effects	post(t) = 0

extern void get_wallclock_time(or_st_time& t);
// modifies	"t"
// effects	post(t) = wall-clock time

extern void add_time(or_st_time& t, or_st_time const& x);
// modifies	"t"
// effects	post(t) = pre(t) + x

extern void sub_time(or_st_time& t, or_st_time const& x);
// modifies	"t"
// effects	post(t) = pre(t) - x

extern double time_to_seconds(or_st_time const& t);
// effects	Return time in seconds.

or_st_time float_to_time(float t);
// effects: Converts t (in seconds) to seconds and microseconds and
//          returns the result

// Disk statistic per disk operation type
struct or_st_disk {
    int			count;		// Number of operations
    int			blocks;		// Total blocks transferred for ops
    or_st_time		elapsed;	// Total elapsed time for ops
};

// Structure of "OR_stat" message
struct OR_stat {
    or_st_time	clock;		// OR wall-clock time when measurement taken
    Ubits32	trans;		// Number of xactions committed
    Ubits32	mods;		// Number of committed modifications
    Ubits32	absorbed;	// Number of absorbed modifications
    Ubits32	installs;	// Number of modifications installed in segs
    Ubits32	logsize;	// Current log size

    Ubits32	logflush_time;	// Total time spent in log flushes in microsecs
    Ubits32	max_logrecord;	// Largest record appended to log in bytes

    or_st_time	disk_time;	// Wall-clock time according to disk
    or_st_time	disk_used;	// Time disk has been busy
    or_st_disk	disk_total;	// All operations combined
    or_st_disk	disk_mreads;	// Miscellaneous reads
    or_st_disk	disk_mwrites;	// Miscellaneous writes
    or_st_disk	disk_freads;	// Fetch reads
    or_st_disk	disk_ireads;	// Installation reads
    or_st_disk	disk_creads;	// Cleaner reads
    or_st_disk	disk_fwrites;	// Flusher writes
    or_st_disk	disk_cwrites;	// Cleaner writes

    Ubits32	fetches;	// Number of fetches from server cache
    Ubits32	misses;		// Number of misses in server cache
    Ubits32	frag_writes;	// Number of fragments written out so far
    Ubits32	frag_sizes;	// Total size of fragments written out so far
    Ubits32	clean_count;	// Number of cleaned regions
    Ubits32	clean_live;	// Amount of live data in cleaned regions

    // TM stats gathered by FE_manager
    or_st_time  total_recv_time;     // Time to receive the commit request
    or_st_time  total_validate_time; // Time to validate the commit
    or_st_time  total_send_time;     // Time to send the commit request
    or_st_time  total_trans_time;    // Time to receive the commit request

    or_st_time  total_fetch_time;    // Time spent in handling fetches

    bool encode(Network*) const;
    bool decode(Network*);
};

extern void sub_stats(OR_stat& s, OR_stat const& x);
// modifies	"s"
// effects	post(s) = pre(s) - x

extern void report_stats(FILE* f, OR_stat const& s);
// effects	Report statistics from "s" to stream "f".

#endif /* _OR_STAT_H */
