#include <stdio.h>
#include "utils/sort.h"
#include "oref.h"

#define QUICK_SORT_ELEMENT Oref
#include "utils/impl_sort.t"

void Sort_orefs(Oref* list, int n) {
    quick_sort(list, n);
}

void Oref_unparse(Oref oref, char *str) {
    Uint sindex = Oref_sindex(oref);
    Uint pnum, onum;
    Pagenum_onum_from_index(sindex, pnum, onum);
    sprintf(str, "[%u:%u:%u]", Oref_segment(oref), pnum, onum);
}

void Oref_print(Oref oref, FILE *fp) {
    if (!fp) fp = stderr;
    char str[40];
    Oref_unparse(oref, str);
    fprintf(fp, "%s", str);
}
