#ifndef _OREF_CONTROL_H
#define _OREF_CONTROL_H

// Control file for oref sets.

#include "oref.h"

// XXX For speed, we disallow high numbered segments

static const Ubits32 oref_empty_sig = 0xFFFFFFFF;
static const Ubits32 oref_del_sig   = 0xFFFFFFFE;

class OrefControl {
  public:
    static int   is_full(Oref);
    static int   is_empty(Oref);
    static int   is_obsolete(Oref);
    static void  make_empty(Oref&);
    static void  make_obsolete(Oref&);
    static int   hash(Oref);
    static int   equal(Oref, Oref);
};

inline int OrefControl::is_full(Oref v) {
    return ((v != oref_del_sig) && (v != oref_empty_sig));
}

inline int OrefControl::is_empty(Oref v) {
    return (v == oref_empty_sig);
}

inline int OrefControl::is_obsolete(Oref v) {
    return (v == oref_del_sig);
}

inline void  OrefControl::make_empty(Oref& v) {
    v = oref_empty_sig;
}

inline void  OrefControl::make_obsolete(Oref& v) {
    v = oref_del_sig;
}

inline int OrefControl::hash(Oref v) {
    return v;
}

inline int OrefControl::equal(Oref a, Oref b) {
    return OREF_EQUAL(a,b);
}

#endif /* _OREF_CONTROL_H */
