#include "ros.h"
#include "utils/array.h"
#include "utils/network.h"
#include "utils/th_assert.h"


Ros::Ros(int predict) : rset(predict) {
}

Ros::~Ros() {}


#ifndef NDEBUG
static bool check_ros(Orefs const *rsetp) {
    Oref prev = 0;
    int rsize = rsetp->size();
    for (int i = 0; i < rsize; i++) {
	if (!Oref_lt(prev, rsetp->slot(i)))
	    return FALSE;
	prev = rsetp->slot(i);
    }
    return TRUE;
}
#endif


void Ros::sort() {
    int sz = rset.size();
    Sort_orefs(rset.as_pointer(), sz);
}

void Ros::print (FILE* fp) {
    int rsize = rset.size();
    if (!fp) fp = stderr;

    fprintf(fp, "Ros: Rsize=%-d\n", rsize);
    for (int j=0; j<rsize; j++) {
	fprintf(fp, "   Oref = %d:%-d \n", 
		Oref_page(rset[j]), Oref_index(rset[j]));
    }
}

bool Ros::encode(Network* net) const {
    th_assert(check_ros(&rset), "Ros has duplicates or is not sorted");
    return encode_orefs(&rset, net); 
}

bool Ros::decode(Network* net) {
    return decode_orefs(&rset, net); 
}
