#ifndef _C_SHORTP_H
#define _C_SHORTP_H

/* See also "fe/runtime/shortp.h".

   This include file is used by C code and may not include C++-isms.
 */

#include <stddef.h>
#include "utils/basic.h"
#include "utils/bits.h"
#include "utils/th_assert.h"
#include "common/slot.h"

/* A "Shortp" is really a "Slot"
*/
typedef Slot Shortp;

/* Machine dependent conversions: The conversion between short and
   long pointers is machine dependent. In a machine with pointers
   longer than 32 bits the higher order 32-bits are fixed. The current
   implementation for the alpha assumes that they are zero.
*/
#if defined __alpha || defined __linux__

/* void *SHORTP_AS_FULL_V(Slot sp)
      effects: convert "sp" to its full representation
   Slot FULL_AS_SHORTP(void *p)
      effects: convert "p" to its short representation
*/
#define SHORTP_AS_FULL_V(sp)  ((void*)(ptrdiff_t)sp) 
#define FULL_AS_SHORTP(p)  ((Shortp)(ptrdiff_t)p)

#endif

/* Machine-independent conversions

   T *SHORTP_AS_FULL<T>(type T, Shortp sp)
     effects: convert "sp" to its full representation as a T *.
*/
#define SHORTP_AS_FULL(T,SP) ((T *)SHORTP_AS_FULL_V(SP))

/* SHORTP_IS_DATA(Shortp sp)
     requires: "sp" must be an object slot, and not a pointer to object
               fields
     effects: Return whether "sp" is actually an Oref
*/
#define SHORTP_IS_DATA(SP) ((SP) & 0x1)
#define SHORTP_IS_PTR(SP) (!SHORTP_IS_DATA(SP))
#define DATA_TO_SHORTP(D) ((((Shortp)(D)) << 1) | 1)
#define SHORTP_AS_DATA(T,SP) ((T)((SP) >> 1))
    
#endif /* _C_SHORTP_H */
