#!/usr/local/bin/expect --

# Some useful functions for using expect

proc th_assert {cond str} {
    # effects: if cond is true, returns "OK\n" else sends str to the user
    #          and terminates the program

    if {$cond} {
	return "OK\n"
    } else {
	send_user "FAILED: $str\n"
	exit
    }
}

proc is_valid_spawnid {id} {
    # effects: returns 1 if id is a valid spawnid else returns 0

    set result [catch {	exp_pid -i $id }]
    return [expr ! $result]
}

proc hostname_to_address {machname} {
    # effects: returns the internet address of machname
    set hostnumber [exec nslookup $machname]
    # This may not be a reliable test
    if {[llength $hostnumber] < 8 || \
	    [regexp [lindex $hostnumber 7] "18\.26\..*"]} {
	send_user "Nslookup failed: $hostnumber [llength $hostnumber]\n"
	exit -1
    }
    set hostnumber [lindex $hostnumber 7]
    return $hostnumber
}

proc close_process {id} {
    # effects: if id is a valid spawn id, closes the connection to it (and
    #          performs a wait). Even if it is not able to close the process
    #          it performs a wait on it to prevent defnuct processes

    set  result1 [catch {
	close -i $id
    } errorstring1]

    set  result2 [catch {
	if {$result1} {
	    wait -nowait -i $id
	} else {
	    wait -i $id
	}
    } errorstring2]
}

proc kill_process {machine_name process_name} {
    # effects: Kill all process belonging to the user on machine "machine_name"
    #          that have name process_name

    global G_hostname
    set pid [process_exists $process_name $machine_name]
    if {!$pid} {
	return
    }

    set count 0
    set total_count 0
    while {$pid} {
	set  result [catch {
	    if {![string compare $G_hostname $machine_name]} {
		exec kill -HUP $pid
	    } else {
		exec rsh $machine_name kill -HUP $pid
	    }
	} errorstring]

	incr count
	if {$count > 9} {
	    # The process  is still executing. Kill the script
	    incr total_count $count
	    send_user "\n$process_name did not get killed after\
            $total_count tries\n"
	    set count 0
	}
	set pid [process_exists $process_name $machine_name]
    }
}

proc process_exists {process_name machine} {
    # returns:If the fe or or (given by process_name) exists on machine, it
    #         returns the PID of that process else returns 0
    #         If a number of processes are found it will return one of the
    #         processes

    global G_hostname
    set grep_expr "\"\[0-9\] $process_name\""
    set process_search "ps uxww | egrep $grep_expr"
    set result [catch {
	if {[string compare $G_hostname $machine]} {
	    set process_line [exec rsh $machine $process_search]
	} else {
	    set process_line [exec ps uxww | egrep "\[0-9\] $process_name"]
	}
    } errorstring]

    if {$result} {
#	send_user "Error $errorstring\n"
	set process_line {}
    }

    if {[llength $process_line]} {
	set process_pid [lindex $process_line 1]
	return $process_pid
    }
    return 0
}

proc send_user_expect_out {str} {
    # effects: Sends str to the user after stripping off
    #          the \r at the second last position

    set length [string length $str]
    set result [string range $str 0 [expr $length - 3]]
    send_user "$result\n"
}

proc send_file {fileid iflog str} {
    # requires: fileid refers to a writeable file
    # effects: Sends str to the the file given by fileid
    #          G_to_screen is TRUE, sends the output to the screen
    #          iflog indicates whether logging is to be really done or not
    #          It matters only when G_to_screen is false
    global G_to_screen

    regsub -all "\r" $str "" str

    if {$G_to_screen} {
	send_user $str
    }
    if {$iflog} {
	puts $fileid $str nonewline
	set result [ catch {flush $fileid} errorstring]
    }
}

# Useful regular expressions
set num_regexp "(\[0-9\]+)"
#set till_end "\[^\r\]*\r\n"
set till_end "\[^\r\]*"

# Some initializations
set G_hostname [exec hostname]
set G_hostname [exec basename $G_hostname .lcs.mit.edu]
set username [exec logname]
set verbose 0
set timeout -1
log_user 0
# Whether data has to be send to the screen or not
set G_to_screen 0

set G_linestr   "---------------------------------------------------------------"
set G_eqlinestr "==============================================================="
