/*
\section{Xref Interface}

An "Xref" bundles up an OR identifier and an OR-specific reference.
*/

#ifndef _XREF_H
#define _XREF_H

#include <stddef.h>
#include <stdio.h>
#include "utils/bits.h"
#include "oref.h"
#include "or_num.h"
    

class Xref {
public:
    OR_num orx;
    Oref oref;

    Xref (): orx(0), oref(0) {}
    // Creates a null xref.

    bool is_null() {return orx == 0 && oref == 0;}

    bool operator==(Xref const &x) const {
	return or_num_equal(orx, x.orx) && Oref_equal(oref, x.oref);
    }

    int hash() const {
	return (int) ((((Uint) orx) * 1737350766) & 0x7fffffff) ^ 
	    (int) ((((Uint) oref) * 1737350766) & 0x7fffffff);
    }
    
    void print(FILE *fp = NULL) {
	if (!fp) fp = stderr;
	char str[100];
	Oref_unparse(oref, str);
	fprintf(fp, "<%u %s>", orx, str);
    }

};

inline bool Xref_equal(Xref a, Xref b) { return a == b;}
inline int Xref_hash(Xref a) {return a.hash();}

#endif 
