#ifndef _CACHE_DEBUG_H
#define _CACHE_DEBUG_H

#if DEBUG_CACHE

void print_class(Xref class_xref);
  /* Print (using printf) the textual name of a well-known class, 
     or the raw xref of a normal class. 
  */

void print_bitfield(Obj_bitfield bf);
  /* Print (using printf) the contents of a bitfield.  The all-data
     bitfield prints as "all data", the all-ref bitfield prints as
     "all refs".  Other bitfields are displayed in hex.
     XXX Doesn't handle long bitfields yet. 
  */

void print_real_or_obj(void *start);
  /* Print (using printf) a representation for an OR object. This
     depends on the OR object being correct.  
  */

void print_or_obj(void* point, int nulls);
  /* print an OR_obj.  Skip /nulls/ slots before interpreting header,
     then uses print_real_or_obj to print the rest. */

void print_or_obj_from_descs(cacheval* chunk, or_objdesc* descs, int index);
  /* print an OR_obj when the descriptors are available.  Index
     starts at 0.  There is little or no error recovery from 
     providing a bad index value.
  */

void print_stuffed_or_obj(void* chunk);
  /* print an OR_obj where the number of nulls has been stuffed into 
     the first word. 
  */

ubits32 commit_send_to_or (Xref *xrefs, ubits32* vnums, int size);

void commit_debug (int l, int u);
  /* Commits a transaction with orefs at OR 1, in segment 0 from l to u.
  */

#endif /* DEBUG_CACHE */

#endif /* _CACHE_DEBUG_H */
