#ifndef _LRU_replacer_h
#define _LRU_replacer_h 1

#include "utils/array.h"
#include "utils/openhashmap.h"
#include "utils/hashfuncs.h"
#include "common/or_num.h"
#include "common/page.h"
#include "common/xref.h"
#include "optimal_replacer.h"

class Stack_refs;

class LRU_replacer : public Trace_replacer {
  // 
  // Implements lru page replacement in the cache using a trace file
  // (FE->trace_file) describing all the accesses.  It maintains a
  // list of Trace_list_entry with entries for all cached pages which
  // is used to perform optimal page replacement, i.e.  the page that
  // is was least recently used is replaced. Currently only
  // works for read-only traversals and traversals that only access
  // objects from OR 1.
  //


public:
  LRU_replacer(Stack_refs const *sr);
  // Effects: Creates an lru page replacer.
  // Requires: FE->trace_file is open for reading and refers to 
  //   a valid trace file. and "sr" keeps track of pointers from the stack or
  //   registers into the page cache.

  ~LRU_replacer();
  // Effects: Deletes the LRU_replacer recovering all the 
  //   allocated storage.
 
  void bring_up_to_date(Uint access_counter);
  // Effects: Brings cached list up-to-date.
  
  Page *replace_page();
  // Effects: Computes the LRU page to replace (constrained 
  //   to not being referenced from the stack) and returns it.

  void add_page(OR_num orx, Uint page_id);
  // Effects: Add entry for page "p" to the list of cached pages.

private:
  Stack_refs const *sr;       // Pointer to storage arena being managed.
  Trace_list_entry *cached_list; // List with trace entries for cached pages.
};

#endif //_LRU_replacer_h







