#include "utils/Monitor.h"

#include "compiler/C++wrappers/fields.h"
#include "compiler/C++wrappers/core.h"
#include "compiler/C++wrappers/class.h"

#include "page_map.h"
#include "surrogate_table.h"
#include "persistent_cache.h"
#include "frame_info.h"

#if CHECK_UNSWIZ
// static iovec iov[UIO_MAXIOV];
#define MAX_ELEMS 50000
#define CHECK_RECON 1
#if CHECK_RECON
static iovec iov[MAX_ELEMS];
#endif

void send_denied_message(OR_num or) {
    // Send a fetch denied message to the OR
    fprintf(stderr, "Fetch denied should not happen %d\n", or);
}

bool get_orig_copy(Fields f) {
    return !f->is_invalid();
}

void Persistent_cache::check_unswizzling() {
    // Select n random pages and swizzle  a fraction f of objects on each page

#define COPY_SCHEME 0
#define PERFECT_MULTIPLES 1
#define FREQ_POWER 1
#define FREQ_MASK ((1 << FREQ_POWER) - 1)

#if PERFECT_MULTIPLES
    // For 32.5% k & 7 < 5, for 62.5% k & 7 < 3
    //#define MASK_COND(k) ((k & 7) < 5)
#define MASK_COND(k) ((k & FREQ_MASK) != 0)
#else
#define MASK_COND(k) ((k & FREQ_MASK) == FREQ_MASK)
#endif

#define NUM_PAGES 1000

    // int f = 25; // 25%
    int st = 200;
    int divide = NUM_PAGES;
    // register int check_every = 100/f;
    // Choosing page ids st to st+n-1
    // register int num_unswizzled = 0;
    // register int total_handled = 0;

#if CHECK_RECON
    Timer recon_timer;
    int net_recv_lengths_arr[MAX_ELEMS]; // We don't initialize it. Do we care?
    Installed net_recv_onums_arr[NUM_PAGES];
    int isize = net_recv_onums_arr[0].size();
    Installed* const net_recv_onums = &net_recv_onums_arr[0];
    int* const net_recv_lengths = &net_recv_lengths_arr[0];

    for (int i = 0; i <NUM_PAGES; i++) {
	for (int k = 0; k < isize; k++) {
	    // Set the onum numbers so that the entry is TRUE if we want the
	    // object to be "received" from the net
	    // In the code below, the loop over which the code is going through
	    // is more than what is needed
	    net_recv_onums[i].reset(k);
	    if (MASK_COND(k))
		continue;
	    net_recv_onums[i].set(k);
	}
    }

    register iovec* const local_iov = &iov[0];
    register int icount = 0;
    
    // Measure the cost of reconstruction by looking up a pageid and then
    // filling the iovec structure according to whether the object is
    // installed or not. If installed, we ignore the object
    recon_timer.start();

    int a = 0;
    for (int i = st; i < st+NUM_PAGES-1; i++, a++) {
	 Page* const orig = pmap->lookup(1, i);
	 register const Frame_info* const pinfo = page_frame_info + index(orig);
	 register Uint const osize = orig->header.osize;
	 const Installed* const objs_recv = &net_recv_onums[a];
	 for (register Uint k = 0; k < osize; k++) {
	     // Now setup the iovec entry for this object
	     // If the object is installed, ignore the duplicate object
	     // For this performance test, since all objects are installed
	     // we will perform the pinfo test but not use it really
	     if (objs_recv->test(k) && pinfo->is_installed(k)) {
		 // Using the opposite test for pinfo
		 Uint offset = orig->header.offsets[k];
		 local_iov[icount].iov_base = (char *) &orig->data[offset];
		 local_iov[icount].iov_len = net_recv_lengths[icount];
		 icount++;
		 // Note that we are not touching the object
		 // Also I guess the else clause will refer to an "ignore"
		 // array but the cost of that should be less than this??
		 // We are never resetting icount and hence our
		 // iovec array is quite big
	     }
	 }
    }
    recon_timer.stop();
    fprintf(stderr, "Perfect multiples = %d, Freq power = %d\n",
	    PERFECT_MULTIPLES, FREQ_POWER);
    fprintf(stderr, "Recon = %f, Avg recon = %f, Num per page = %f\n",
	    recon_timer.elapsed(), recon_timer.elapsed()/divide,
	    ((float)icount)/divide);;

#else
    Timer unswiz_timer;

#if COPY_SCHEME
    Page copies[NUM_PAGES];
    Timer copy_timer;
    // Check copying speed
    Page *first = pmap->lookup(1, 0);
    copy_timer.start();
    int kx = 0;
    for (int i = st; i < st+NUM_PAGES-1; i++, kx++) {
	memcpy(&copies[kx], &first[i], Page_size);
    }
    copy_timer.stop();

    // Check the copy + lookup costs
    kx  = 0;
    Timer copy_lookup_timer;
    copy_lookup_timer.start();
    for (int i = st; i < st+NUM_PAGES-1; i++, kx++) {
	Page *orig = pmap->lookup(1, i);
	memcpy(&copies[kx], orig, Page_size);
    }
    copy_lookup_timer.stop();

#else

    // Set up the "log" of entries to be undone
    struct Undo_rec {
	short offset; // Offset in the page where the value to be reverted
	Slot value;   // The old value
    };
    Undo_rec* const urec = new Undo_rec[8*1024];
    // Undo_rec *prec = new Undo_rec[8*1024];
    register int ucount = 0;
    int total_pcount = 0;
#endif

    // register int obj_count = 0;
    unswiz_timer.start();
    //resume_monitor();
    int j = 0;

    for (int i = st; i < st+NUM_PAGES-1; i++, j++) {
	Page *orig = pmap->lookup(1, i);
	if (!orig) {
	    fprintf(stderr, "Page %d missing\n", i);
	}
#if COPY_SCHEME
	register Page *copy_page = &copies[j];
	memcpy(copy_page, orig, Page_size);
#else
	register Page* const copy_page = orig;
	ucount = 0;
#endif
	// Unswizzle f% of objects on this now
	register const Frame_info* const pinfo = page_frame_info + index(orig);
	// We have to go over the page frame info object and check every
	// 100/fth object
	register Uint const osize = copy_page->header.osize;
	OR_num const or = copy_page->get_or();
	register Uint k = 1;
	if (or)
	    k = 0; // This is for invalid check in page
	for (; k < osize; k++) {
	    // total_handled++;
	    if (!pinfo->is_installed(k) || MASK_COND(k))
		continue;
	    // Unswizzle this object.
	    register Uint offset = copy_page->header.offsets[k];
	    OR_obj *to_unswiz = (OR_obj *) &copy_page->data[offset];
	    Fields f = (Fields) to_unswiz;
	    Core c = f->to_core();
	    if (f->is_written()) {
		if (!get_orig_copy(f)) {
		    fprintf(stderr, "Original copy missing\n");
		    send_denied_message(1);
		}
	    }
	    //num_unswizzled++;
	    Class_c cl((Obj)c->get_class());
	    Xref class_xref = cl.class_xref();
	    Oref class_oref = class_xref.oref;
	    if (class_xref.or == 25) { // XXX Wrong test so that it does fail!!
		class_oref = FE->surr_table->lookup(class_xref.or,
						    class_xref.oref, or);
		th_assert(!Oref_equal(class_oref, NULL_OREF),
			  "Class oref not found");
	    }

	    th_assert(!Oref_equal(class_oref, NULL_OREF),
		      "Class oref not found");
#if !COPY_SCHEME
	    // Keep information about the old info in the header slot
	    urec[ucount].offset = offset;
	    urec[ucount++].value = *((Slot *)to_unswiz);
#endif
	    to_unswiz->set_class_oref(class_oref);
		
	    register Obj_bitfield bf = c->bitfields();
	    if (bf == OBJ_BF_ALLDATA) continue;
	    if (bf == OBJ_BF_ALLREFS)
		bf = Obj_all_refs_set; XXX this is broken objects can be bigger
                XXX than 32 slots.
	    register Uint nslots = c->num_slots();
	    //obj_count++;

	    // Iterate through all the slots of the object and unswizzle them
	    register Obj_x* const slots = (Obj_x *)to_unswiz->fields();
	    for (register Uint slotno = 0; slotno < nslots; slotno++) {
		if (!OBJ_BF_ISREF(bf, slotno))
		    continue;
		register Obj_x &cur_slot = slots[slotno];
		if (cur_slot.is_data()) continue;

		// Swizzled pointer needs to be unswizzled
		Core const target = (Core) cur_slot.pointer();
		//Oref target_oref = target->oref();

		Xref target_xref = target->xref();
		th_assert(target->is_persistent(),
			  "Unswizzling ref to volatile obj");
		Oref target_oref = target_xref.oref;
		if (target_xref.or != or) {
		    target_oref = FE->surr_table->lookup(target_xref.or,
							 target_xref.oref, or);
		    th_assert(!Oref_equal(target_oref, NULL_OREF),
			      "Target oref not found");
		}
#if !COPY_SCHEME
		// Keep information about the old info in the header slot
		urec[ucount].offset  = offset + slotno + 1;
		urec[ucount++].value = copy_page->data[offset + slotno + 1];
#endif
		cur_slot.store_data(target_oref);
	    }
	}
#if !COPY_SCHEME
	// Revert the objects to the original state. The page has been
	// sent. Note: If we do this after all pages have been sent,
	// then we also need to keep track of the pages that were touched
	total_pcount += ucount;
	register Slot* page_slots = (Slot *) orig;
	for (int g = 0; g < ucount; g++) {
	    Undo_rec *rec = &urec[g];
	    page_slots[rec->offset] = rec->value;
	}
#endif
    }

    unswiz_timer.stop();
    //stop_monitor();
    //    fprintf(stderr, "Handled %d pages (%d objects), unswizzled %d\n",
    //n, total_handled, num_unswizzled);
    float time_spent = unswiz_timer.elapsed();
    fprintf(stderr, "Perfect multiples = %d, Freq power = %d\n",
	    PERFECT_MULTIPLES, FREQ_POWER);
    fprintf(stderr, "Total Time = %f, Per page = %f, Ref per page %f\n",
	    time_spent, time_spent/divide, ((float)total_pcount)/divide);
    //fprintf(stderr, "Objects unswizzled per page = %f\n",
    //((float)obj_count)/divide);
#if COPY_SCHEME
    fprintf(stderr, "Copy = %f, Copy + Lookup = %f\n",
	    copy_timer.elapsed(), copy_lookup_timer.elapsed());
#endif

#endif // if ! CHECK_RECON


}
#endif
