#include "utils/mdebug.h"
#include "surrogate_table.h"

implementOpenHashMap(Xref_to_Xrefs, Xref, Xrefs*, Xref_hash, Xref_equal)

Xrefs empty_xrefs; // Array used for dealing with empty surrogate tables

Surrogate_table::Surrogate_table() {}
Surrogate_table::~Surrogate_table() {}

Surrogate_table::Iter::Iter(Surrogate_table* table): iter(&table->rep) {
    if (!iter.ok())
	current = &empty_xrefs;
    else {
	dest_xref = iter.key();
	current = iter.val();
    }
    index = 0;
}

bool Surrogate_table::Iter::get(Xref &dest, Xref &surr) {
    if (index < current->size()) {
	dest = dest_xref;
	surr = current->slot(index++);
	return TRUE;
    }
    iter.next();
    if (!iter.ok()) return FALSE;
    index = 0;
    dest_xref = iter.key();
    current = iter.val();
    return TRUE;
}

Oref Surrogate_table::lookup(OR_num orx, Oref oref, OR_num surr_or) {
  Xrefs *surrs;
  Xref x;
  x.orx = orx; x.oref = oref;

  // Search the table for surrogates for x=<or,oref>...  
  if (rep.fetch(x, surrs)) {
    // Search for a surrogate at surr_or
    int i;
    int size = surrs->size();

    // We use linear search here because we expect size to be very small.
    for (i=0; i < size; i++) {
      if (surrs->slot(i).orx == surr_or) {
	// there is a surrogate at surr_or, return its oref
	return surrs->slot(i).oref;
      }
    }
  } 
      
  // If no appropriate surrogate was found return null
  return NULL_OREF;
}


void Surrogate_table::insert(OR_num orx, Oref oref, 
			     OR_num surr_or, Oref surr_oref) {
  Xrefs *surrs;
  Xref target_x;
  target_x.orx = orx; target_x.oref = oref;  
  Xref surr_x;
  surr_x.orx = surr_or; surr_x.oref = surr_oref;

  // Check if there are surrogates in the table for target_x=<or,oref>...  
  if (rep.fetch(target_x, surrs)) {
    surrs->append(surr_x);
  } else {
    surrs = new Xrefs(1);
    surrs->append(surr_x);
    rep.store(target_x, surrs);
  }
}

void Surrogate_table::remove(OR_num orx, Oref oref) {
  Xrefs *surrs;
  Xref target_x;
  target_x.orx = orx; target_x.oref = oref;  
  // Check if there are surrogates in the table for target_x=<or,oref>...  
  if (rep.fetch(target_x, surrs)) {
    delete surrs;
    rep.remove(target_x);
  }
}



