#ifndef _Trace_replacer_h
#define _Trace_replacer_h 1

#include "utils/array.h"
#include "utils/openhashmap.h"
#include "utils/hashfuncs.h"
#include "common/or_num.h"
#include "common/page.h"
#include "common/xref.h"


//
// Trace entry for each run "r" of consecutive accesses to 
// a page "page_id" ending in access number "last_access".
//
struct Trace_entry {
  Uint page_id;
  Uint last_access;

  bool operator< (Trace_entry const &t) { return last_access < t.last_access;}
  bool operator> (Trace_entry const &t) { return last_access > t.last_access;}
  bool operator<= (Trace_entry const &t) { return last_access <= t.last_access;}
};


class Trace_replacer {
  // 
  // Generic interface for page replacers that read a trace file with 
  // future accesses to make replacement decisions.
  //


public:
  virtual ~Trace_replacer() {}
  // Effects: Deletes the LRU_replacer recovering all the 
  //   allocated storage.
 
  virtual void bring_up_to_date(Uint access_counter) = 0;
  // Effects: Brings bookeeping information up-to-date to account
  //   for all the object accesses since it was last called.
  
  virtual Page *replace_page() = 0;
  // Effects: Computes a page to replace (constrained 
  //   to not being referenced from the stack) and returns it.
  // Requires:  bring_up_to_date was called.


  virtual void add_page(OR_num orx, Uint page_id) = 0;
  // Effects: Add entry for page "p" signalling p was fetched.
};

#endif //_Trace_replacer_h







