#ifndef Cplus_Class_c_h
#define Cplus_Class_c_h 1

#include "compiler/C/dv.h"

#include "typedefs.h"
#include "core.h"

#include "common/obj_bitfield.h"
#include "common/xref.h"

class Class_c {

  /* Overview: Wrapper class for struct Class_s defined in fe/compiler/C */
  
public:
  Class_c();
  /* Effects: Creates an unitialized Class_c object */

  Class_c(struct Class_s * cl);
  /* Effects: Creates a Class_c object initialized to refer to cl. */
  
  int num_slots();
  /* Effects: For classes whose objects have a fixed number of slots,
       returns the number of slots excluding the header of the fields
       portion of the object. Otherwise returns -1. */

  int hdr_size();
  /* Effects: Returns the dispatch header size (in slots)
       for objects of this class. */

  Obj_bitfield bitfields();
  /* Effects: Returns the bit fields for objects of this class. */
   
  void init_disp_hdr(Core c);
  /* Requires: Core c must be a pointer to a previously allocated core
       with enough words to store the dispatch header for this class above.
     Effects: Initializes the dispatch header of c*/

  Xref class_xref();
  /* Effects: Returns the xref of the class object */

  static void init_disp_hdr_prim(Core c, struct DV_hdr_s *methods);
  /* Requires: Core c must be a pointer to a previously allocated core
       for an object with a single dispatch header word, and methods is 
       a dispatch vector for the object.
     Effect: Initializes the dispatch header of c.
       Notes: A more primitive version of "init_disp_hdr" that can be
       used even before the class object has been initialized. This
       ability is needed to bootstrap the system. */

private:
  struct Class_s *rep; 
};

inline Class_c::Class_c() {}

inline Class_c::Class_c(struct Class_s * cl) {rep = cl;}

inline int Class_c::num_slots() {return rep->dv->num_slots;}

inline int Class_c::hdr_size()  {return 1;}
/* Obsolete: Was used when multiple dispatch vectors were supported */

inline Obj_bitfield Class_c::bitfields() {return rep->dv->bf;}

inline void Class_c::init_disp_hdr(Core c) { 
  c->set_dv(rep->dv); 
}

inline void Class_c::init_disp_hdr_prim(Core c, struct DV_hdr_s * dv) {
  c->set_dv(dv);
}

inline Xref Class_c::class_xref() {
  Xref x; x.orx = Null_or; x.oref = rep->oref;
  return x;
}

#endif /* Cplus_Class_c_h */
