#ifndef _C_DV_H
#define _C_DV_H

#include "obj.h"
#include "methods.h"

#include "common/obj_bitfield.h"
#include "common/oref_basic.h"


struct DV_hdr_s;


struct Class_s {
  Oref oref;

  Obj_p name;       /* java_lang_String *name; class name */
  Obj_p meta_obj;   /* java_lang_Class meta_obj; */
  Obj_p *strings;   /* java_lang_String *strings; list of string constants */

  int flags;	    /* isInterface, isArray, isPrimitive, etc. */

  struct DV_hdr_s *dv;	/* Pointer to the corresponding struct DV_hds_s */

  /* The following fields are used only if (flags & IS_STATIC) */

  Obj_p static_obj;	/* Pointer to the per-class static object */

  /* The following fields are used only if (flags & IS_ARRAY) */

  struct Class_s *elem_class;	/* Pointer to the class of array elements */

  /* The following fields are used only if (flags & IS_PRIMITIVE) */

  int size;             /* sizeof(type) */

};


/* "DV_hdr_s" is the header on all object dispatch vectors.  This contains
   information that is meaningful only in case of "classes" (Interfaces in
   Java are types but not classes.) */

struct DV_hdr_s {

  /* Points to the corresponding Class_s structure */
    struct Class_s *self_class; 

  /* bitfields describing all objects of this class.  See
     "thor/common/obj_bitfield.h" for details. */
    Obj_bitfield bf; 

  /* number of slots in object, or -1 if
     objects with this dv have variable number of slots */
    int num_slots;    

  /* The following fields are used only in case of DVs of non-static
     objects.  For static objects, we just store 0 in these fields. */

  /* number of methods in object */
    int num_methods;    

  /* "methods" contains a copy of all method pointers in this dv, along
     with the hashcodes of the method signatures.  This is used for runtime
     lookup for invoking interface methods.  To facilitate quick lookups,
     "methods" is kept sorted based on the hashcodes.  */
    struct Method_s *methods; 

    int nsupers;			/* number of superclasses incl self */
    struct Class_s **supers;	/* list of superclasses incl self */
    int ninters;			/* number of interfaces implemented */
    int ndinters;		/* number of directly implemented interfaces */
    struct Class_s **inters;	/* list of interfaces */
    int nothers;			/* number of other known classes */
    struct Class_s **others;	/* list of other known classes */
};

/* The dispatch vector on all objects */

struct Obj_DV {
    struct DV_hdr_s hdr;
    /* Method pointers here */
    /* void(*M)(); ... */
};


#define GET_STATIC_OBJ(OT) ((OT)(self_P->OT##_V->static_obj))

/*
    int GET_NUM_METHODS(Objp O);
      Return the number of methods in this object

    struct Class_s * GET_CLASS(Objp O);
      Return the class_object corresponding to the class of this object


The following are defined to keep some legacy code functional

    int GET_dhsize(Class_s c);
      Usually 1, unless there a multiple dispatch vectors.

    int GET_head_offset(Class_s c);
      Usually 0, unless there a multiple dispatch vectors.

    int GET_core_offset(Class_s c);
      Usually 0, unless there a multiple dispatch vectors.

*/

#endif /* _C_DV_H */
