#ifndef _C_EXTERN_H
#define _C_EXTERN_H

/*
    This header file captures all EXTERNAL dependencies of the
    code in fe/runtime/C. These routines are not called directly
    by compiler-generated code.
*/

#ifdef __cplusplus
extern "C" {
#endif

#include <stdarg.h>
#include <setjmp.h>
/* For handling failure */

#include "obj.h"
#include "fields.h"
#include "methods.h"
#include "basic_types.h"
#include "array.h"
#include "exceptions.h"

struct Core_s;
struct Class_s;

extern void Log_read(struct Core_s *o);
    /* log a read to the object "o". See runtime trans_log.cc */
extern void Log_write(struct Core_s *o);
    /* log a write to the object "o". See runtime trans_log.cc */
extern void Log_new(struct Core_s *o);
    /* log creation of object "o". See runtime trans_log.cc */

extern void *Alloc_class(unsigned size);
    /* Allocates size bytes in the code cache. See volatile_heap.cc  */

extern struct Core_s *ROT_table;
    /* The resident object table */

#define ROT_FETCH(i) (ROT_table + (i))
   /*  Core_p ROT_FETCH(int i);
           Fetch core from ROT given its index */

#define ROT_INDEX(c) ((c) - ROT_table)
   /*  int  ROT_FETCH(Core_p c);
           Get the index of a core c in the ROT */

extern Fields_p Make_resident(struct Core_s *c);
   /* requires: c is not resident
      effects:  Make the core "c" resident, updating its fields pointer, and
      return the new fields pointer. Implemented in swizzle_table.cc */

extern struct Obj_s *Cache_swizzle(Fields_p v, Shortp oref, struct Class_s *cl);
    /* Fetch (if necessary) the object denoted by the Oref contained in
       "oref" and in the same OR as "v", and construct a pointer to it
       that is compatible with the type described by "cl".
       Implemented in fe/cache/swizzle_table.cc  */

extern struct Obj_s *Allocate_object(struct Class_s *classobj, int size);
    /* Allocate an object of class "classobj" and return a pointer to the
       object. "size" contains the number of bytes in variable-sized objects;
       it should be zero for fixed-size objects. Implemented in 
       resident_object_table.cc */

extern struct Obj_s *Allocate_object_raw(int dhsize, int size,
					 bool variable_size);
    /* See specs for Resident_object_table::allocate_object_raw
       Implemented in resident_object_table.cc */

extern void (*Dispatch_Interf(struct Method_s *methods, int n, int hashcode))();
    /* Requires: "methods" is an array of size n, and, 
         "methods" is sorted according to hashcode.
       Effects: Returns the method whose hashcode is equal to
         "hashcode", by doing a runtime lookup in methods[] */

extern int InstanceOf(Object o, struct Class_s  *c, int ndim);
    /* Requires: o is any object, but not null,
         c is any class
       Effects: o is checked for assignability to an n-dimensional array of c
         If n is zero, o is checked for assignability to an object of type c */

extern int FindHandler(struct handler *h, int tsize, Object exception, int oldpc);
    /*  Effects: search table to find handler */

extern void Throw(Object o);
    /*  Effects: Throw an arbitrary exception */


extern struct Class_s *Instantiate_array(struct Class_s *T);
    /* Effects: Instantiates and returns a class which is an array of T */

extern Array MNewArray(struct Class_s *c, char type, int nDim, int nArgs,/*l1,l2*/...);
   /* Effects: Creates a multi-dimensional array of type c.  The array has
      nDim dimensiona, but the array size is known only for the first nArgs
      dimensions (l1,l2,...).  Hence, space is allocated only for the first
      nArgs dimensions. 'type' describes the type of elements of the
      nArg'th dimension */

extern void Eager_ref_count_update(Shortp oldp, struct Core_s *newp);
    /* Updates reference counts to reflect a pointer update. oldp
       should be the initial content of the ivar being updated; If
       swizzled it must point to a core and the reference count of the
       core it refers to is decremented. newp is the new value to be
       stored in the ivar. It must point to a core. The reference
       count for the core it refers to is incremented. See
       ref_counts.cc */
            
extern void Execution_trace(struct Fields_s *v);
    /* Effects: Trace access to "v" and store trace in  FE->trace_file.
       Requires: "v" is the fields of a valid object and 
         FE->trace_file is open for reading.  */

/* Counter of the number of different object accesses */
extern unsigned long Access_counter;


extern void Add_init_queue(void (*func)(void *env), void *env);
    /* Add another work item to the end of the current initialization
       queue for the runtime system boot process. The argument "env"
       will be passed to "func" when it is invoked. */

extern void Pin_object(Obj_p x);
    /* Ensure that "x" is never garbage-collected */

#ifdef __cplusplus
}
#endif
#endif /* _C_EXTERN_H */
