#ifndef _C_OBJ_H
#define _C_OBJ_H

#include "common/shortp.h"
#include "common/oref_basic.h"
#include "utils/bits.h"

/* A "Core_s" is the portion of the object's entry in the ROT that starts
   with the word containing the class dispatch vector.  Usually, Obj_p and
   Core_p point to the same structure, unless an object has multiple
   dispatch vectors. */

typedef struct Obj_s {
    Shortp dv;
} *Obj_p;

typedef struct Core_s {
    Shortp dv;
    Shortp fields;        /* short pointer to instance variables */
    Oref oref_;           /* object's oref */
    Ubits32 rc8_next24;   /* reference count :8 | next pointer :24 */
} *Core_p;

/*
    T_DV GET_DV(Obj_p o, type T);
      Return the methods pointer of an object of type T.

    void SET_DV(Obj_p o, struct T##_DV *D);
      Sets the dv of o to be D.

    Fields_p GET_FIELDS(Obj_p o);
      Return the fields of o (which should be resident).

    void SET_FIELDS(Obj_p o, struct Field_s *F);
      Sets the fields of o (which should be resident) to be F.

    See "runtime/C/residency.h" for details on object residency states.

The following are defined to keep some legacy code functional

    Core_p OBJ_CORE(Obj_p O);   
      Should add core_offset if multiple dispatch vectors are really used.

    Obj_p OBJ_HEAD(Obj_p O);   
      Should add head_offset if multiple dispatch vectors are really used.

    int OBJ_HDR_SIZE(Obj_p O);   
      Should be (core_offset - head_offset)/sizeof(Slot) + 1

    int Header_offset(struct Class_s *from_t, struct Class_s *to_t);
      Return the proper offset for converting from a value of type
      "from_t" to a value of type "to_t".  The type "to_t" must be either
      a supertype or subtype of "from_t".
*/

#define GET_DV(O,T) SHORTP_AS_FULL(struct T##_DV, ((Obj_p)(O))->dv)
#define SET_DV(O,D) (((Obj_p)(O))->dv = FULL_AS_SHORTP(D))

#define GET_BIDIRECTIONAL_DV(O,OT) ((struct OT##_bidirectional_DV *) \
  ((char *)GET_DV(O, OT) - offsetof(struct OT##_bidirectional_DV, hdr)))

#define GET_FIELDS(O) SHORTP_AS_FULL(struct Fields_s, ((Core_p)(O))->fields)
#define SET_FIELDS(O,F) (((Core_p)(O))->fields = FULL_AS_SHORTP(F))

#define OBJ_CORE(O) (Core_p)(O)
#define OBJ_HEAD(O) (Obj_p)(O)
#define OBJ_HDR_SIZE(O) (1)
#define Header_offset(OT, ST) 0

#endif /* _C_OBJ_H */
