#include "compiler/C/compiler.h"

#include "java_lang_NullPointerException.h"

/*  findhandler(table, size, exceptn, oldpc) -- search table to find handler */

int FindHandler(struct handler *h, int tsize, Object exception, int oldpc)
{
    struct Class_s *ex_class;

    if (exception == JAVA_NULL)	/* if NULL, mutate to NullPointerException */
      THROW_G(java_lang_NullPointerException);

    while (tsize-- > 0) {
	if ((unsigned)oldpc >= h->start_pc
	&&  (unsigned)oldpc <  h->end_pc
	&&  (((ex_class = *h->class_ptr) == 0)
	     || InstanceOf(exception, ex_class, 0)))
	    return h->handler_pc;
	h++;
    }
    return -1;
}

/*
 *  Throw(o) -- throw an arbitrary exception
 *
 *  called from generated code and from below.
 */

void Throw(Object o)
{
    struct mythread *thr = mythread();

    thr->exception = o;
    longjmp(thr->jmpbuf, 1);
}
