#include "compiler/C/flags.h"
#include "compiler/toba.h"

/* interfinstance(cl, interf) -- does cl implement the interface interf? */

static int interfinstance(struct Class_s *cl, struct Class_s *interf)
{
    int i;

    for (i = 0; i < cl->dv->ninters; i++) {
        if (cl->dv->inters[i] == interf)
 	    return 1;
        if(interfinstance(cl->dv->inters[i], interf))
            return 1;
    }
    return 0;
}


/* 
 *  instanceof(o, c, n) -- is o an instance of an array of n dims of class c?
 *
 *  o is any object, but not null.
 *  c is any class
 *
 *  o is checked for assignability to an n-dimensional array of c.
 *  If n is zero, o is checked for assignability to an object of type c.
 */ 
int InstanceOf(Object o, struct Class_s  *c, int ndim)
{
    int dim;
    struct Class_s *oc = GET_DV(o, Obj)->hdr.self_class;

    dim = ndim;
    while (c->flags & IS_ARRAY) {       /* find underlying target class */
        c = c->elem_class;
        dim++;
    }

    while (oc->flags & IS_ARRAY) {
        oc = oc->elem_class;             /* find underlying element classes */
        dim--;
    }

    if (dim > 0) return 0;              /* dimension mismatch */

    if (dim == 0) {
      if (oc == c) return 1;

      if ((oc->flags | c->flags) & IS_PRIMITIVE)
	return 0;                       /* if primitive, must be identical */
      if (c->flags & IS_INTERFACE)
        return interfinstance(oc, c);   /* if an interface, check specially */

      /* At this point c is a simple class */
      return ((oc->dv->nsupers >= c->dv->nsupers) && 
	      (oc->dv->supers[oc->dv->nsupers - c->dv->nsupers] == c));
    }

    /* (oc,dim) is an array, so it can matches only java.lang.Object */
    return (oc->dv->supers[oc->dv->nsupers-1] == c);
}
