/*  sthreads_null.h -- null sthreads interface */

/*
 * Copyright 1996, 1997 Arizona Board of Regents; see COPYRIGHT file for
 * details.
 */

#ifndef h_sthreads
#define h_sthreads

#include <stdio.h>
#include <setjmp.h>	/* used by generated code for try/catch */

#include "java_lang_Object.h"

/* thread-specific info */
struct mythread {
    void *jmpbuf;		/* current setjmp buffer */
    Object exception;		/* current exception */
    jmp_buf default_jmpbuf;	/* initial jump buffer */
    int exception_count;		/* number of uncaught exceptions */
};

/* per-thread control block */
typedef struct tcb {
    struct mythread mythread;		/* toba per-thread stuff */
    Object obj;            		/* the Thread object */
    int state;				/* thread state */
    int defer;
} tcb;


#ifdef __cplusplus
extern "C" {
#endif

extern void sthread_init();
extern struct mythread *mythread();
extern void sthread_got_exception(void);

#ifdef __cplusplus
}
#endif

#endif /* h_sthreads */
