/*
 * @(#)System.java	1.72 97/11/14
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

package java.lang;

import java.io.*;
import java.util.Properties;
import java.util.StringTokenizer;

/**
 * The <code>System</code> class contains several useful class fields 
 * and methods. It cannot be instantiated. 
 * <p>
 * Among the facilities provided by the <code>System</code> class 
 * are standard input, standard output, and error output streams; 
 * access to externally defined "properties"; a means of 
 * loading files and libraries; and a utility method for quickly 
 * copying a portion of an array. 
 *
 * @author  Arthur van Hoff 
 * @version 1.72, 11/14/97
 * @since   JDK1.0
 */
public final
class System {
    /** Don't let anyone instantiate this class */
    private System() {
    }

    /** 
     * Copies an array from the specified source array, beginning at the
     * specified position, to the specified position of the destination array.
     * A subsequence of array components are copied from the source 
     * array referenced by <code>src</code> to the destination array 
     * referenced by <code>dst</code>. The number of components copied is 
     * equal to the <code>length</code> argument. The components at 
     * positions <code>srcOffset</code> through 
     * <code>srcOffset+length-1</code> in the source array are copied into 
     * positions <code>dstOffset</code> through 
     * <code>dstOffset+length-1</code>, respectively, of the destination 
     * array. 
     * <p>
     * If the <code>src</code> and <code>dst</code> arguments refer to the 
     * same array object, then the copying is performed as if the 
     * components at positions <code>srcOffset</code> through 
     * <code>srcOffset+length-1</code> were first copied to a temporary 
     * array with <code>length</code> components and then the contents of 
     * the temporary array were copied into positions 
     * <code>dstOffset</code> through <code>dstOffset+length-1</code> of the 
     * argument array. 
     * <p>
     * If any of the following is true, an 
     * <code>ArrayStoreException</code> is thrown and the destination is 
     * not modified: 
     * <ul>
     * <li>The <code>src</code> argument refers to an object that is not an 
     *     array. 
     * <li>The <code>dst</code> argument refers to an object that is not an 
     *     array. 
     * <li>The <code>src</code> argument and <code>dst</code> argument refer to 
     *     arrays whose component types are different primitive types. 
     * <li>The <code>src</code> argument refers to an array with a primitive 
     *     component type and the <code>dst</code> argument refers to an array 
     *     with a reference component type. 
     * <li>The <code>src</code> argument refers to an array with a reference 
     *     component type and the <code>dst</code> argument refers to an array 
     *     with a primitive component type. 
     * </ul>
     * <p>
     * Otherwise, if any of the following is true, an 
     * <code>ArrayIndexOutOfBoundsException</code> is 
     * thrown and the destination is not modified: 
     * <ul>
     * <li>The <code>srcOffset</code> argument is negative. 
     * <li>The <code>dstOffset</code> argument is negative. 
     * <li>The <code>length</code> argument is negative. 
     * <li><code>srcOffset+length</code> is greater than 
     *     <code>src.length</code>, the length of the source array. 
     * <li><code>dstOffset+length</code> is greater than 
     *     <code>dst.length</code>, the length of the destination array. 
     * </ul>
     * <p>
     * Otherwise, if any actual component of the source array from 
     * position <code>srcOffset</code> through 
     * <code>srcOffset+length-1</code> cannot be converted to the component 
     * type of the destination array by assignment conversion, an 
     * <code>ArrayStoreException</code> is thrown. In this case, let 
     * <b><i>k</i></b> be the smallest nonnegative integer less than 
     * length such that <code>src[srcOffset+</code><i>k</i><code>]</code> 
     * cannot be converted to the component type of the destination 
     * array; when the exception is thrown, source array components from 
     * positions <code>srcOffset</code> through
     * <code>srcOffset+</code><i>k</i><code>-1</code> 
     * will already have been copied to destination array positions 
     * <code>dstOffset</code> through
     * <code>dstOffset+</code><i>k</I><code>-1</code> and no other 
     * positions of the destination array will have been modified. 
     *
     * @param      src:      the source array.
     * @param      srcpos    start position in the source array.
     * @param      dest      the destination array.
     * @param      destpos   start position in the destination data.
     * @param      length    the number of array elements to be copied.
     * @exception  ArrayIndexOutOfBoundsException  if copying would cause
     *               access of data outside array bounds.
     * @exception  ArrayStoreException  if an element in the <code>src</code>
     *               array could not be stored into the <code>dest</code> array
     *               because of a type mismatch.
     * @since      JDK1.0
     */
    public static native void arraycopy(Object src, int src_position,
                                        Object dst, int dst_position,
                                        int length);

}
