class BaseAssembly extends Assembly {

  int id_;
  int buildDate_;
  byte[] otype_;
  ComplexAssembly super_;

  CompositePart[] sub_;
  int sub_i; // size of sub_

  public BaseAssembly(int id, int buildDate, byte[] otype, ComplexAssembly ca){

	// OOO Constant
	sub_ = new CompositePart[OO7_Creator.NumCompPerAssm];
	sub_i = 0;

	id_ = id;
	buildDate_ = buildDate;
	otype_ = otype;
	super_ = ca;
  }

  public int id() {
    return id_;
  }

  public int buildDate() {
    return buildDate_;
  }

  public void set_buildDate(int date) {
	buildDate_ = date;
  }

  public byte[] otype() {
  	return otype_;
  }

  public void init_superAssembly(ComplexAssembly _super) {
	super_ = _super;
  }

  public ComplexAssembly superAssembly() {
    return super_;
  }

  public int traverse(Traversal t) {
	int result = 0;

	int i;
	for (i=0; i<sub_i; i++)
	  result = result + sub_[i].traverse(t);

	return result;
  }

  public int traverse_random(Traversal t) {
	int result = 0;

	int i;
	for (i=0; i<sub_i; i++)
	  result = result + sub_[i].traverse_random(t);

	return result;
  }

  public int traverse_random_path(Traversal t) {
	return sub_[myUtil.rand_int()%3].traverse_random(t);
  }

  public void add_subPart(CompositePart part) {
	sub_[sub_i++] = part;
  }
  
  public CompositePart subPart(int i) {
	return sub_[i];
  }

}
