// Meeting.java

public class Meeting extends Item {

  // This class represents a Meeting in a Calendar.

  Time startTime, endTime;
  int length;

  public Meeting(String name, String description) {
    super(name, description);
    this.startTime = new Time();
    this.endTime = new Time();
    /* need to fix this for multiple day meetings */
    length = endTime.offset - startTime.offset;
  }

  public Meeting(String name, String description,
		 Date startDate, Date endDate,
		 Time startTime, Time endTime) {
    super(name, description, startDate, endDate);
    this.startTime = startTime;
    this.endTime = endTime;
    /* need to fix this for multiple day meetings */
    length = endTime.offset - startTime.offset;
  }

  public Time startTime() {
    return startTime;
  }

  public Time endTime() {
    return endTime;
  }

  public int length() {
    return length;
  }

  public byte[] write() {

    byte apptHeader[] = { (byte)'A', (byte)'p', (byte)'p', (byte)'t' };
    byte startHeader[] = { (byte)'S', (byte)'t', (byte)'a', (byte)'r', (byte)'t' };
    byte lengthHeader[] = { (byte)'L', (byte)'e', (byte)'n', (byte)'g', (byte)'t', (byte)'h' };

    byte space[] = { (byte)' ' };
    byte enter[] = { (byte)'\n' };
    byte openBracket[] = { (byte)'[' };
    byte endBracket[] = { (byte)']' };

    byte buffer[] = new byte[0];
    buffer = Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(buffer,apptHeader),space),openBracket),enter),startHeader),space),openBracket);

    buffer = Util.concat(buffer,startTime.write());

    buffer = Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(buffer,endBracket),enter),lengthHeader),space),openBracket),Util.itostr(this.length,10)),endBracket),enter);
    
    buffer = Util.concat(Util.concat(Util.concat(buffer,super.write()),endBracket),enter);    
    
    return buffer;
  }

  public String toString() {
    
    byte meetingHeader[] = { (byte)'M', (byte)'e', (byte)'e', (byte)'t', (byte)'i', (byte)'n', (byte)'g' };
    byte fromHeader[] = { (byte)'F', (byte)'r', (byte)'o', (byte)'m', (byte)':', (byte)' ' };
    byte toHeader[] = { (byte)'T', (byte)'o', (byte)':', (byte)' ' };

    byte enter[] = { (byte)'\n' };
    byte space[] = { (byte)' ' };

    byte buffer[] = new byte[0];
    buffer = Util.concat(Util.concat(buffer,meetingHeader),enter);
    
    String superStr = super.toString();
    int len = superStr.length();
    byte tmp[] = new byte[len];
    superStr.getBytes(0,len,tmp,0);
    buffer = Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(Util.concat(buffer,tmp),fromHeader),startTime.write()),enter),toHeader),endTime.write()),enter);

    return new String(buffer,0);
  }

}


