// Creation of oo7 DB.

public class OO7_Creator {

  // oo7 parameters.
  public static int NumAtomicPerComp = 20;
  public static int NumConnPerAtomic = 3;
  public static int DocumentSize = 2000;
  public static int ManualSize = 100*1000;
  public static int NumCompPerModule = 500;
  public static int NumAssmPerAssm = 3;
  public static int NumAssmLevels = 7;
  public static int NumCompPerAssm = 3;
  public static int NumModules = 1;

  // arbitrarily chosen oo7 parameteres
  public int TitleSize = 64;
  public int TypeSize = 10;

  public void set_medium() {
    // Sets the parameters for medium oo7.
    NumAtomicPerComp = 200;
    DocumentSize = 20*1000;
    ManualSize = 1000*1000; 
  }

  public void set_large() {
    // Sets the parameters for large oo7.
    set_medium(); 
    NumModules = 2; 
  }

  public OO7DB DB() {
    OO7DB db = new OO7DB(NumAtomicPerComp, NumConnPerAtomic, DocumentSize, 
			 ManualSize, NumCompPerModule, NumAssmPerAssm, 
			 NumAssmLevels, NumCompPerAssm, NumModules); 

    for (int i = 0; i < NumModules; i++) {
      OO7Module mod = Module();
      db.add_mod(mod);
    }
    return db;
  }

  public OO7Module Module() {

    byte[] s1 = random_string(TitleSize);
    byte[][] s2 = random_string_array(ManualSize);
    byte[] s3 = random_string(TypeSize);

    Manual man = new Manual(next_id(), s1, s2);
    ComplexAssembly dummy = new ComplexAssembly();
    Assembly root = Assemblies(1, dummy);

    OO7Module mod = new OO7Module(next_id(), myUtil.rand_int(),s3, root,man);
    man.init_mod(mod);
    return mod;
  }

  public Assembly Assemblies (int level, ComplexAssembly dummy) {
    Assembly as;
    if (level == NumAssmLevels) { // BaseAssembly
      byte[] s = random_string(TypeSize);
      BaseAssembly bs = new BaseAssembly(next_id(), myUtil.rand_int(),s, dummy);
      // Do not create the composites now 
      // to avoid creating large numbers of objects unreachable from root.
      as = bs;
    } else { // ComplexAssembly
      byte[] s = random_string(TypeSize);
      ComplexAssembly cs = new ComplexAssembly(next_id(), myUtil.rand_int(),
					       s, dummy);
      as = cs;
      for (int i = 0; i < NumAssmPerAssm; i++) {
	Assembly sub = Assemblies(level+1, cs);
	sub.init_superAssembly(cs);
	cs.add_subAssembly(sub);
      }
    }
    return as;
  }

  public void Composites(OO7DB db) {
    AtomicPart dummy = new AtomicPart();
    for (int i = 0; i < NumModules; i++) {
      // Create a null array of pointers to composite parts.
      // to be filled on demand.
      OO7Module mod = db.mod(i);
      Assembly root = mod.rootAssembly();
      // Create the modules' composite parts.
      for (int j=0; j < NumCompPerModule; j++)
	mod.add_composite(Composite(dummy));
      // Link base assemblies to composites. 
      Composites(root, mod);
    }
  }

  public void Composites(Assembly as, OO7Module mod) {
    if (as instanceof BaseAssembly) {
      BaseAssembly bs = (BaseAssembly)as;
      for (int i = 0; i < NumCompPerAssm; i++) {
	int j = myUtil.rand_int() % NumCompPerModule;
	CompositePart comp = mod.fetch_composite(j);
	bs.add_subPart(comp);
	comp.add_superAssembly(bs);
      }
    } else { // is a ComplexAssembly
      ComplexAssembly cs = (ComplexAssembly) as;
      for (int i = 0; i < NumAssmPerAssm; i++) {
	Assembly sub = cs.subAssembly(i);
	Composites(sub, mod);
      }
    }
  }

  public CompositePart Composite(AtomicPart dummy) {
    byte[] s1 = random_string(TitleSize);
    byte[][] s2 = random_string_array(DocumentSize);
    CompositePart dc = new CompositePart();;
    Document doc = new Document(next_id(), s1, s2, dc) ;
    byte[] s3 = random_string(TypeSize);
    CompositePart cpart = new CompositePart(next_id(), myUtil.rand_int(), 
					    s3,doc,dummy);
    doc.init_part(cpart);
    AtomicPart aparts[] =  Atomics(cpart, doc.docId());
    for (int i = 0; i < NumAtomicPerComp; i++) {
      cpart.add_subPart(aparts[i]);
    }
    if (! thor.Thor.commit())
      throw new RuntimeException();
    return cpart;
  }

  public AtomicPart[] Atomics(CompositePart cpart, int docId) {
    AtomicPart[] aparts = new AtomicPart[NumAtomicPerComp];
    for (int i = 0; i < NumAtomicPerComp; i++) {
      byte[] s = random_string(TypeSize);
    
      AtomicPart aparts_i2 = new AtomicPart(next_id(), myUtil.rand_int(), s, 
					    docId, myUtil.rand_int(), 
					    myUtil.rand_int(), cpart);
					  
      aparts[i] = aparts_i2;
    }
    // Interconnect the atomic parts.
    for (int k = 0; k < NumAtomicPerComp; k++) {
      // Connect to the next part.
      connect_parts(aparts, k, (k+1) % NumAtomicPerComp);
      // Make remaining connections at random.
      for (int j = 0; j < NumConnPerAtomic-1; j++) {
	connect_parts(aparts, k, myUtil.rand_int() % NumAtomicPerComp);
	// XXX Allows multiple connections between two atomic parts.
	// XXX Allows connections to self.
      }
    }
    return aparts;
  }

  public void connect_parts(AtomicPart aparts[], int i, int j) {
    byte[] s = random_string(TypeSize);
    Connection con = new Connection(s, myUtil.rand_int(), aparts[i], aparts[j]);
    aparts[i].add_outConnection(con);
    aparts[j].add_inConnection(con);
  }

  private static int id = 0;
  public int next_id() {
    // Returns a unique id.
    return (++id);
  }

  public byte[] random_string (int length) {
    byte[] ths = new byte[length]; // Should String contents also be inited?
    return (ths);
  }

  public byte[][] random_string_array (int length) {

    int num_strings = (length-1) / 8000 + 1;
    int length_of_last_string = (length-1) % 8000 + 1;

    byte[][] ths = new byte[num_strings][]; // Should contents be inited?
    for (int i=0; i<num_strings-1; i++)
      ths[i] = new byte[8000];
    ths[num_strings-1] = new byte[length_of_last_string];

    return (ths);
  }

  /*
  public static void main(String args[]) {
    OO7_Creator creator = new OO7_Creator();

    creator.set_medium(); // Medium db

    OO7DB db;
    int result;
    long t1, t2;
    int n = 3; // repeat count 3 (Hot)
    int kind;

    db = creator.DB();
    creator.Composites(db);
    System.out.println("Created db");

    kind = 6; // traversal 6
    for (int i=0; i<n; i++) {
      t1 = java.lang.System.currentTimeMillis();
      result = db.traverse(kind);
      t2 = java.lang.System.currentTimeMillis();
      System.out.println("result = " + result + ", kind = " + kind);
      System.out.println("Time for traversal = " + (t2-t1) + " ms");
    }

    kind = 1; // traversal 1
    for (int i=0; i<n; i++) {
      t1 = java.lang.System.currentTimeMillis();
      result = db.traverse(kind);
      t2 = java.lang.System.currentTimeMillis();
      System.out.println("result = " + result + ", kind = " + kind);
      System.out.println("Time for traversal = " + (t2-t1) + " ms");
    }
  }
  */
} // class OO7_Creator
