public class intset {

  int[] slots; // slots to store elements
  int m;		  // the size of slots is always a power of 2
  int num_elems;	  //number of elements in set

  public intset(int size) {
	// % returns a new empty intset to hold at most ceiling(log(size)) elements
	size *= 2;
	int mask = 1;
	while (mask < size) {
	  mask <<= 1;
	}
	slots = new int[mask]; 
	m = mask;
	num_elems = 0;
  }

  public void insert(int k) {

	int j = find_index(k);
	// if (j == 0) then signal bounds end
	if (j < 0) { // k is not in the set
	  slots[-j-2] = k;
	  num_elems = num_elems + 1;
	}
  }

  public boolean member(int k) {
	int i = find_index(k);
	return (i >= 0);
  }

  public boolean empty() {
	return (num_elems == 0);
  }

  public int size() {
	return (num_elems);
  }

  public void clear() {
	num_elems = 0;

	int i;
	int l = slots.length;

	for (i=0;  i<l; i++) {
		slots[i] = 0;
	}
  }

  public int find_index(int k) {
    // % Finds i that is the earliest hashed value of k such that
    // % slots[i] = k or slots[-i] = 0.
    // % Returns -i-2 if slots[i] = 0,  and i if slots[i] = k.
    // % Returns -1 if no such value of i exists (as when set is full).
  
	// % first hash based on division
	int i;
	i = k & (m-1);
		
	// %% p: int
	// %% ivector_fetch(p, slots, i)
	int p = slots[i];
	if (p == k) return (i);
	if (p == 0) return (-i-2);

	// % use linear rehashing 
	int q = 0;
	while (!(p == k ||  p == 0 || q == m)) {
	  i++;
	  if (i == m) 
		i = 0;
	  // %ivector_fetch(p, slots, i) 
	  p = slots[i];
	  q++;
	}

	if (q == m) return (-1);
	if (p == 0)
	  return (-i-2);
	else 
	  return (i) ;
  }

}

