package thor;

public class Thor {

// Overview: This class provides procedural abstractions to access 
// persistent roots and to commit transactions.

  public native static Directory getRoot();
  // Effects: Returns the persistent root.
  
  public native static boolean commit();
  // Modifies: The local object heap and the persistent store.
  // Effects: If the transaction cannot be serialized with respect to all
  //		other committed transactions, aborts the transaction 
  //		and returns false.
  //	Else, commits the transaction and returns true.
  //	In either case, starts a new transaction when the current 
  //              transaction ends.
}
