#include <stream.h>
#include <stdlib.h>
#include <string.h>
#include <iostream.h>
#include <fstream.h>
#include <unistd.h>
#include <pwd.h>

#include "utils/Timer.h"
#include "utils/Monitor.h"

#include "common/oref.h"

#include "compiler/sthreads.h"
#include "compiler/C/compiler.h"

#include "runtime/tm.h"
#include "runtime/stats.h"

#include "cache1/resident_object_table.h"
#include "cache1/persistent_cache.h"

#include "fe_config.h"

#include "config/vdefs/CHECK_UNSWIZ.h"

#include "java/builtins/exports/java.h"
#include "java/thor/exports/java.h"
#include "java/source/exports/java.h"

// effects: copies str into a new location pointed to by return value
char* copy_string(char const* str) {
    char* out = new char[strlen(str)+1];
    strcpy(out, str);
    return out;
}

// effects: returns current username
static char const* my_name() {
  static char const* name = 0;	// My user name

  // Fetch my name from user database
  struct passwd* pw = getpwuid(getuid());
  if (pw != 0) name = copy_string(pw->pw_name);
  
  return name;
}

// effects: returns a Java String object whose value is the first length
//          characters in str
static java_lang_String make_string(Calendar_Creator creator,
				    char str[], int length) {
  int i;

  // make a new byte array to pass to String constructor
  Byte_Array A;
  ALLOC_ARRAY_RAW_G(A, Byte, length, Byte_V);
  struct Byte_Array_f_s *f = FIX_FIELDS(A, Byte_Array);
  for(i=0; i<length; i++) {
    PUTAV_F(f, i, str[i], Byte);
  }

  // call CreateString in Calendar
  java_lang_String s = DISPATCH_N_D((Calendar_Creator) creator,
				    CreateString_ab_On8rk_,
				    Calendar_Creator)(creator, 
						      (java_lang_Object)A);
  FE->rot->obj_to_handle((Obj) s);

  return s; 
}

// effects: writes value of str into the first length characters of result
static void get_string(java_lang_String str, char * result, int length) {

  int i;

  // make a new byte array to pass to String getBytes
  Byte_Array A;
  ALLOC_ARRAY_RAW_G(A, Byte, length, Byte_V);
  struct Byte_Array_f_s *f = FIX_FIELDS(A, Byte_Array);
  for(i=0; i<length+1; i++) {
    PUTAV_F(f, i, 0, Byte);
  }

  // call getBytes in String
  DISPATCH_V_D((java_lang_String) str,
	       getBytes_iiabi_36VfN,
	       java_lang_String)(str, 0, length, (java_lang_Object)A, 0);

  // print contents of str
  f = FIX_FIELDS(A, Byte_Array);
  for (i=0; i<length; i++) {
    GETAV_F(result[i],f,i,Byte);
  }
  result[length] = '\0';

}

// effects: adds a new meeting to the calendar
static void add_meeting(thor_Directory root, Calendar_Creator creator,
			char * uid) {

  CalendarDB db = (CalendarDB)(DISPATCH_V_D((thor_Directory) root,
					    get_i_34DvE,
					    thor_Directory))(root, 1010);

  java_lang_String juid = make_string(creator,
				      uid, strlen(uid));

  Calendar cal = (Calendar)(DISPATCH_V_D((CalendarDB) db,
					 getCalendar_S_A2LPu,
					 CalendarDB))(db,juid);
     
  // get data from the user
  cout << "Enter a name for the meeting: ";
  char name_str[100];
  cin.getline(name_str,100);
  java_lang_String jname_str = make_string(creator,
					   name_str, strlen(name_str));

  cout << "Enter a description of the meeting: ";
  char desc_str[500];
  cin.getline(desc_str,500);
  java_lang_String jdesc_str = make_string(creator,
					   desc_str, strlen(desc_str));

  Date jstart_date = (Date_s *)JAVA_NULL;
  while (jstart_date == (Date_s *)JAVA_NULL) {

    cout << "Enter the date of the meeting (MM-DD-YYYY): ";
    char start_date_str[100];
    cin >> start_date_str;

    if ((strlen(start_date_str) != 10) || 
	(start_date_str[2] != '-') ||
	(start_date_str[5] != '-')) {
      jstart_date = (Date_s *)JAVA_NULL;
    }
    else {
      int month, day, year;
      char * foo = new char[5];
      strncpy(foo, start_date_str, 2);
      foo[2] = '\0';
      month = atoi(foo);
      strncpy(foo, start_date_str+3, 2);
      foo[2] = '\0';
      day = atoi(foo);
      strncpy(foo, start_date_str+6, 4);
      foo[4] = '\0';
      year = atoi(foo);

      jstart_date = DISPATCH_N_D((Calendar_Creator) creator,
				 CreateDate_iii_Qfoht_,
				 Calendar_Creator)(creator, day, month, year);
      delete foo;
    }
  }

  Time jstart_time = (Time_s *)JAVA_NULL;
  while (jstart_time == JAVA_NULL) {

    cout << "Enter the start time of the meeting (HH24:MM): ";
    char start_str[100];
    cin >> start_str;

    if ((strlen(start_str) != 5) || 
	(start_str[2] != ':')) {
      jstart_time = (Time_s *)JAVA_NULL;
    }
    else {
      int hours, minutes;
      char * foo = new char[3];
      strncpy(foo, start_str, 2);
      foo[2] = '\0';
      hours = atoi(foo);
      strncpy(foo, start_str+3, 2);
      foo[2] = '\0';
      minutes = atoi(foo);

      jstart_time = DISPATCH_N_D((Calendar_Creator) creator,
				 CreateTime_ii_bs3j6,
				 Calendar_Creator)(creator, hours, minutes);
      delete foo;
    }
  }

/*
  Date jend_date = JAVA_NULL;
  while (jend_date == JAVA_NULL) {

    cout << "Enter the end date of the meeting (MM-DD-YYYY): ";
    char end_date_str[100];
    cin >> end_date_str;

    if ((strlen(end_date_str) != 10) || 
	(end_date_str[2] != '-') ||
	(end_date_str[5] != '-')) {
      jend_date = JAVA_NULL;
    }
    else {
      int month, day, year;
      char * foo = new char[5];
      strncpy(foo, end_date_str, 2);
      foo[2] = '\0';
      month = atoi(foo);
      strncpy(foo, end_date_str+3, 2);
      foo[2] = '\0';
      day = atoi(foo);
      strncpy(foo, end_date_str+6, 4);
      foo[4] = '\0';
      year = atoi(foo);

      jend_date = DISPATCH_N_D((Calendar_Creator) creator,
			       CreateDate_iii_Qfoht_,
			       Calendar_Creator)(creator, day, month, year);

    }
  }
*/

  Time jend_time = (Time_s *)JAVA_NULL;
  while (jend_time == (Time_s *)JAVA_NULL) {

    cout << "Enter the end time of the meeting (HH24:MM): ";
    char end_str[100];
    cin >> end_str;

    if ((strlen(end_str) != 5) || 
	(end_str[2] != ':')) {
      jend_time = (Time_s *)JAVA_NULL;
    }
    else {
      int hours, minutes;
      char * foo = new char[3];
      strncpy(foo, end_str, 2);
      foo[2] = '\0';
      hours = atoi(foo);
      strncpy(foo, end_str+3, 2);
      foo[2] = '\0';
      minutes = atoi(foo);

      jend_time = DISPATCH_N_D((Calendar_Creator) creator,
			       CreateTime_ii_bs3j6,
			       Calendar_Creator)(creator, hours, minutes);
      delete foo;
    }
  }

  Meeting m = DISPATCH_N_D((Calendar_Creator) creator,
			   CreateMeeting_SSDDTT_n6lgv,
			   Calendar_Creator)(creator,
					     jname_str,
					     jdesc_str,
					     jstart_date,
					     jstart_date,
					     jstart_time,
					     jend_time);
  DISPATCH_V_D((Calendar) cal, 
	       addItem_I_3UE80,
	       Calendar)(cal, (Item)m);

  if (FE->tm->commit()) 
    cout << "Added meeting\n";
  else
    cout << "Failed to add meeting\n";

}

// effects: add new notice to calendar
static void add_notice(thor_Directory root, Calendar_Creator creator,
		       char * uid) {

  CalendarDB db = (CalendarDB)(DISPATCH_V_D((thor_Directory) root,
					    get_i_34DvE,
					    thor_Directory))(root, 1010);

  java_lang_String juid = make_string(creator,
				      uid, strlen(uid));

  Calendar cal = (Calendar)(DISPATCH_V_D((CalendarDB) db,
					 getCalendar_S_A2LPu,
					 CalendarDB))(db,juid);
     
  // get data from the user
  cout << "Enter a name for the notice: ";
  char name_str[100];
  cin.getline(name_str,100);
  java_lang_String jname_str = make_string(creator,
					   name_str, strlen(name_str));

  cout << "Enter a text of the notice: ";
  char note_str[500];
  cin.getline(note_str,500);
  java_lang_String jnote_str = make_string(creator,
					   note_str, strlen(note_str));

  Date jstart_date = (Date_s *)JAVA_NULL;
  while (jstart_date == (Date_s *)JAVA_NULL) {

    cout << "Enter the date of the notice (MM-DD-YYYY): ";
    char start_date_str[100];
    cin >> start_date_str;

    if ((strlen(start_date_str) != 10) || 
	(start_date_str[2] != '-') ||
	(start_date_str[5] != '-')) {
      jstart_date = (Date_s *)JAVA_NULL;
    }
    else {
      int month, day, year;
      char * foo = new char[5];
      strncpy(foo, start_date_str, 2);
      foo[2] = '\0';
      month = atoi(foo);
      strncpy(foo, start_date_str+3, 2);
      foo[2] = '\0';
      day = atoi(foo);
      strncpy(foo, start_date_str+6, 4);
      foo[4] = '\0';
      year = atoi(foo);

      jstart_date = DISPATCH_N_D((Calendar_Creator) creator,
				 CreateDate_iii_Qfoht_,
				 Calendar_Creator)(creator, day, month, year);
      delete foo;
    }
  }

  cout << "Enter a length for the notice: ";
  char length_str[10];
  cin >> length_str;
  int length = atoi(length_str);

  Notice n = DISPATCH_N_D((Calendar_Creator) creator,
			  CreateNotice_SSDDi_IZnBx,
			  Calendar_Creator)(creator,
					    jname_str,
					    jnote_str,
					    jstart_date,
					    jstart_date,
					    length);
  DISPATCH_V_D((Calendar) cal, 
	       addItem_I_3UE80,
	       Calendar)(cal, (Item)n);

  if (FE->tm->commit()) 
    cout << "Added notice\n";
  else
    cout << "Failed to add notice\n";
}

// effects: displays menu of items to add
static void add_item(thor_Directory root, Calendar_Creator creator,
		     char * uid) {

  char com;
  cout << endl
       << "M - Add a new meeting\n"
       << endl
       << "N - Add a new notice\n"
       << endl
	<< "Select item to add: ";
  
  cin >> com;
  cin.ignore(1,'\n');

  cout << endl;
    
  switch (com) {

  case 'm':
  case 'M': // Add a new meeting to the calendar
    add_meeting(root, creator, uid);
    break;
    
  case 'n':
  case 'N': // Add a new notice to the calendar
    add_notice(root, creator, uid);
    break;
  }

}

// effects: deletes an item from the calendar
static void delete_item(thor_Directory root, Calendar_Creator creator,
			char* uid) {

  CalendarDB db = (CalendarDB)(DISPATCH_V_D((thor_Directory) root,
					    get_i_34DvE,
					    thor_Directory))(root, 1010);

  java_lang_String juid = make_string(creator,
				      uid, strlen(uid));

  Calendar cal = (Calendar)(DISPATCH_V_D((CalendarDB) db,
					 getCalendar_S_A2LPu,
					 CalendarDB))(db,juid);

  cout << "Enter the number of the item you wish to delete: ";
  char in[5];
  cin >> in;

  int itemNum = atoi(in);
  
  // call getItem in Calendar
  Item item = (DISPATCH_N_D((Calendar) cal,
			    getItem_i_bFaGl,
			    Calendar))(cal,itemNum);

  if (item != JAVA_NULL) {
    java_lang_String out = DISPATCH_V_D((Item) item,
					toString__y21AC,
					Item)(item);
    int length = DISPATCH_N_D((java_lang_String) out,
			      length__rpuzQ,
			      java_lang_String)(out);
    char * tmp = new char[length+1];
    get_string(out,tmp,length);
    cout << "You have chosen to delete the following item:\n" << tmp;
    delete tmp;					
    cout << "Are you sure you want to delete this item (Y/N): ";
    char yn[1];
    cin >> yn;

    if (strcmp(yn,"Y") == 0 || strcmp(yn,"y") == 0) {
      DISPATCH_N_D((Calendar) cal,
		   deleteItem_i_IsMEA,
		   Calendar)(cal,itemNum);
      if (FE->tm->commit()) 
	cout << "Deleted item\n";
      else
	cout << "Failed to delete item\n";
    }
    else {
      cout << "No item was deleted\n";
    }
  }
  else {
    cout << "There is no item numbered " << itemNum << " in the calendar\n";
  }
}

// effects: lists the items currently in the calendar
static void list_calendar(thor_Directory root, Calendar_Creator creator,
			  char* uid) {

  CalendarDB db = (CalendarDB)(DISPATCH_V_D((thor_Directory) root,
					    get_i_34DvE,
					    thor_Directory))(root, 1010);

  java_lang_String juid = make_string(creator,
				      uid, strlen(uid));

  Calendar cal = (Calendar)(DISPATCH_V_D((CalendarDB) db,
					 getCalendar_S_A2LPu,
					 CalendarDB))(db,juid);

  // get the number of items in cal
  int numItems = (DISPATCH_N_D((Calendar) cal,
			       numItems__8lyk4,
			       Calendar))(cal);
  cout << "Number of Items in Calendar: " << numItems << "\n\n";
  
  // get each item in the calendar and print to screen
  for (int i=0; i<numItems; i++) {
    cout << "*** Item # " << i << " ***\n";

    // call getItem in Calendar
    Item item = (DISPATCH_N_D((Calendar) cal,
			      getItem_i_bFaGl,
			      Calendar))(cal,i);

    java_lang_String out = DISPATCH_V_D((Item) item,
					toString__y21AC,
					Item)(item);
    int length = DISPATCH_N_D((java_lang_String) out,
			      length__rpuzQ,
			      java_lang_String)(out);
    char * tmp = new char[length+1];
    get_string(out,tmp,length);
    cout << tmp;
    delete tmp;					
  }

}

// effects: lists the uid's of all calendars in db
static void list_calendars(thor_Directory root, Calendar_Creator creator) {

  CalendarDB db = (CalendarDB)(DISPATCH_V_D((thor_Directory) root,
					    get_i_34DvE,
					    thor_Directory))(root, 1010);

}

// effects: outputs the calendar to a file in ical file format
static void output_calendar(thor_Directory root, 
			    Calendar_Creator creator,
			    char * uid) {

  CalendarDB db = (CalendarDB)(DISPATCH_V_D((thor_Directory) root,
					    get_i_34DvE,
					    thor_Directory))(root, 1010);

  java_lang_String juid = make_string(creator,
				      uid, strlen(uid));

  Calendar cal = (Calendar)(DISPATCH_V_D((CalendarDB) db,
					 getCalendar_S_A2LPu,
					 CalendarDB))(db,juid);

  java_lang_String out = DISPATCH_V_D((Calendar) cal,
				      toFile__yaGQ3,
				      Calendar)(cal);

  int length = DISPATCH_N_D((java_lang_String) out,
			    length__rpuzQ,
			    java_lang_String)(out);
  char * foo = new char[length];
  get_string(out,foo,length);
			   
  cout << "Enter filename: ";
  char name_str[100];
  cin >> name_str;

  ofstream file;
  file.open(name_str, ios::out);
  file << foo;
  delete foo;
}

static char* switch_user(Calendar_Creator creator,
			 thor_Directory root) {

  cout << "Enter username for calendar to switch to: ";
  char uid[100];
  cin >> uid;

  CalendarDB db = (CalendarDB) (DISPATCH_V_D((thor_Directory) root, 
					     get_i_34DvE, 
					     thor_Directory))(root, 1010);  
  // check if calendar exists for give user
  java_lang_String juid = make_string(creator,
				      uid, strlen(uid));
  Calendar tmp_cal = (Calendar) (DISPATCH_V_D((CalendarDB) db, 
					      getCalendar_S_A2LPu,
					      CalendarDB))(db, juid);  
  if (tmp_cal == JAVA_NULL) {
    return 0;
  }
  else {
    return copy_string(uid);
  }
}

// effects: creates calendar for give uid if ones does not exist
static int create_calendar(Calendar_Creator creator,
			   thor_Directory root,
			   char * uid) {

  Calendar calendar = (Calendar)(DISPATCH_V_D((Calendar_Creator) creator, 
					      CreateCalendar__JPIHW, 
					      Calendar_Creator))(creator);

  // Make sure calendar's entry in the ROT does not get discarded.
  FE->rot->obj_to_handle((Obj) calendar);

  CalendarDB db = (CalendarDB) (DISPATCH_V_D((thor_Directory) root, 
					     get_i_34DvE, 
					     thor_Directory))(root, 1010);  

  java_lang_String juid = make_string(creator, uid, strlen(uid));    

  // check if calendar with uid already exists
  Calendar tmp_cal = (Calendar) (DISPATCH_V_D((CalendarDB) db, 
					      getCalendar_S_A2LPu,
					      CalendarDB))(db, juid);  

  if (tmp_cal != JAVA_NULL) {
    return 0;
  }

  // Store the pointer to the calendar into db
  DISPATCH_V_D((CalendarDB) db,
	       addCalendar_CS_9rc72,
	       CalendarDB)(db,calendar,juid);
  
  if (FE->tm->commit())
    cout << "Created and commited calendar\n";
  else
    cout << "Failed to create and commit calendar\n"; 

  return 1;
  
}

static void create_new_calendar(Calendar_Creator creator, 
				thor_Directory root) {

  cout << "Enter username for new calendar: ";
  char uid[100];
  cin >> uid;
  if (!create_calendar(creator, root, uid)) 
    cout << "Calendar for " << uid << " already exists\n";
}

// effects: create CalendarDB if one does not exist and places in 1010 of root
static void create_db(Calendar_Creator calendar_creator, 
		      thor_Directory root) {

  CalendarDB db = (CalendarDB)(DISPATCH_V_D((Calendar_Creator) calendar_creator, 
					  CreateCalendarDB__N74Kl,
					  Calendar_Creator))(calendar_creator);

  // Make sure calendarDB's entry in the ROT does not get discarded.
  FE->rot->obj_to_handle((Obj) db);

  // check if calendarDB exists already
  CalendarDB tmp_db = (CalendarDB) (DISPATCH_V_D((thor_Directory) root, 
						 get_i_34DvE, 
						 thor_Directory))(root, 1010);  

  if (tmp_db == JAVA_NULL) {
    // Store the pointer to the calendar db into thor_Directory
    (DISPATCH_V_D((thor_Directory) root, put_iO_EZlTS, 
		  thor_Directory))(root, 1010, (java_lang_Object) db);
    
    if (FE->tm->commit())
      cout << "Created and commited calendar db\n";
    else
      cout << "Failed to create and commit calendar db\n"; 
  }
}

void calendar_main(thor_Directory root) {

  // allocate new Calendar_Creator
  Calendar_Creator calendar_creator;
  {
    struct Calendar_Creator_P_s *self_P = Calendar_Creator_P;
    ALLOC_OBJ(calendar_creator, Calendar_Creator);
    cout << "Created Calendar_Creator\n";
  }
  FE->rot->obj_to_handle((Obj) calendar_creator);

  // initialize Calendar_Creator
  (DISPATCH_N_D((Calendar_Creator) calendar_creator, init__QKVMs_, Calendar_Creator))(calendar_creator);  
  cout << "Inited Calendar_Creator\n";

  // make sure CalendarDB exists
  create_db(calendar_creator, root);

  // identify current user
  char * current_user = (char*)my_name();

  // make sure calendar exists for current user
  create_calendar(calendar_creator, root, current_user);

  // *** TEST FOR EXCEPTIONS ***
  (DISPATCH_N_D((Calendar_Creator) calendar_creator, test__qm6Df, Calendar_Creator))(calendar_creator);  
  // ***************************

  // make sure calendar_creator is committed (not really persistent)
  if (FE->tm->commit())
    cout << "Created and commited calendar creator\n";
  else
    cout << "Failed to create and commit calendar creator\n"; 

  char com;
  do {
    
    cout << "\n*** " << current_user << "'s Calendar ***\n"
         << endl
         << "S - Switch to another calendar\n"
	 << endl
         << "C - Create a new calendar\n"
	 << endl
	 << "A - Add an item to the calendar\n"
	 << endl
	 << "D - Delete an item from the calendar\n"
	 << endl
	 << "L - List the contents of the calendar\n"
	 << endl
	 << "O - Output the contents of the calendar to an ical file\n"
	 << endl
	 << "Q - Quit\n"
	 << endl
	 << "Enter command: ";
    
    cin >> com;
    cin.ignore(1,'\n');

    cout << endl;
    
    switch (com) {

    case 's':
    case 'S': { // Switch the current user 
      char * tmp_user = switch_user(calendar_creator,root);
      if (tmp_user == 0) {
	cout << "Calendar does not exist for that user\n";
      }
      else {
	current_user = tmp_user;
	cout << "Current calendar is for " << current_user << "\n";
      }
    }
      break;
      
    case 'c':
    case 'C': // Create a new calendar
      create_new_calendar(calendar_creator, root);
      break;

    case 'a':
    case 'A': // Add an item to the current calendar
      add_item(root, calendar_creator, current_user);
      break;

    case 'd':
    case 'D': // Delete an item from the calendar
      delete_item(root, calendar_creator, current_user);
      break;

    case 'l':
    case 'L': // List the contents of the calendar
      list_calendar(root, calendar_creator, current_user);
      break;

    case 'o':
    case 'O': // Output the calendar to a file
      output_calendar(root, calendar_creator, current_user);
      break;
    }
  } while (com != 'Q' && com != 'q');
  
  cout << "Exiting\n";
}








