#ifndef _FE_CONFIG_H
#define _FE_CONFIG_H

// FE_config contains configuration params as well as high-level 
// objects such as the cache manager, transaction manager. 

#include <sys/types.h>
#include "utils/basic.h"
#include "utils/bits.h"
#include "utils/address.h"
#include "common/or_num.h"

#include "java/thor/exports/java.h"

struct sockaddr_in;

class Locator;
class Communication;
class TM;
class Persistent_cache;
class Volatile_heap;
class Resident_object_table;
class OR_info_map;
class Surrogate_table;

class FE_config {
public:
    FE_config(int argc, char* argv[]);
    // Initializes this to default values overridden by options in "argv".

    ~FE_config();

    // root
    thor_Directory root;

    // client interface 
    int			client_port; // also used to specify shm key 
    bool                shm; // use shared memory 
    long                shm_bufsize;
    bool		slave;

    // or interface 
    OR_num              initial_or_num;  // # of OR we initially connect to 
    Locator             *locator;   // For locating FEs and ORs 
    Communication       *comm;      // For communicating with ORs/FEs 

    // cache 
    size_t		cachesize;
    int                 avg_obj;   // Average object size
    int                 max_prefetch;
    
    // Maximum size of undo log for persistent objects (in slots).
    int per_undo_log_size;

    // Maximum space that can be wasted with unreferenced ROT
    // entries expressed as a percentage of tatal cache size.
    int max_rot_waste;  

    // Thresholds for adaptive prefething.
    float              high_threshold; 
    float              low_threshold;                 

    bool                use_eviction; // Whether to use eviction or compaction.

    // Whether or not to do page replacement in the background.
    bool background_replacement;

    // Minimum number of free pages in cache.
    int min_free_pages;
	 
    // Number of scans remembered in  last_scanned.
    int                 scans_remembered; 
                                
    // We scan scan_factor pages per each page we evict. 
    int                 scan_factor;

    // Number of scan pointers  
    int                 num_scan_ptrs;

    // Whether or not secondary scan pointers perform a full scan or just
    // scan for pages with many uninstalled objects.
    bool use_full_scan;
                 
    // Compaction threshold is incremented if less than Page_size/discard_factor
    // bytes were obtained when compacting the last page.
    int                 discard_factor;
                                         
    Persistent_cache    *pc;       // Persistent cache for this FE 
    Volatile_heap       *vh;       // Persistent cache for this FE 
    Resident_object_table *rot;
    TM                  *tm;       // Transaction manager for this FE 
    OR_info_map         *or_map;  // Information maintained per OR
    Surrogate_table     *surr_table; // Surrogate table for this FE.


    // File where to store execution trace.
    FILE *trace_file;

    // compiler 
    char		*srcfile;
    char                *theta_srcfile;
    char		*veneer_srcfile;
    char		*veneer_language;

    // misc
    Address             address;        // Address of this FE
    bool		runInBackground;
    bool                allow_sigio; // Allow SIGIO to be delivered to FE 
    int                 debug_level;     // Debugging info level 

    void init();
    // Initializes FE based on current configuration.
    // Call this after process_options for options to have effect.

private:
    void process_options(int argc, char* argv[]);
    // Process command line options and changes this accordingly.  
    // Fails if there were problems.
};

extern FE_config *FE;             // The configuration of this FE 
extern void **Stack_main;
// points to a pointer aligned slot in the main stack frame

#endif /* _FE_CONFIG_H */
