#include <iostream.h>
#include <stdlib.h>
#include <signal.h>

#include "utils/Monitor.h"
#include "utils/basic.h"

#include "common/or_num.h"
#include "common/oref.h"

#include "fe_config.h"

#include "cache1/persistent_cache.h"
#include "cache1/resident_object_table.h"

#include "compiler/C/compiler.h"

#include "java/thor/exports/java.h"

extern void java_main(thor_Directory);
extern void calendar_main(thor_Directory);

extern void finish_fe();
// directory fe_local_directory;

void **Stack_main; 
FE_config *FE;

static void catch_fpe(int )
{
  cout << "Came here: fe/main.cc: catch_fpe(int)\n";
  // SET_EXC_BUILTIN(overflow);
}


Obj_p init_root(OR_num ornum) {
    Oref oref = FE->pc->get_root(ornum);
    Obj_p root = (Obj_p) FE->rot->install_root(ornum, oref);

    // Assign handle to root object to protect it from eviction.
    FE->rot->obj_to_handle((Obj_c *)root);
    return root;
}


int main(int argc, char *argv[]) {
    void *dummy;  // a dummy reference on stack
    Stack_main = &dummy;

    atexit(finish_fe);
    signal(SIGFPE, catch_fpe);

    FE = new FE_config(argc, argv);
    FE->init();

    sthread_init();

    thor_Directory root = (thor_Directory) init_root(FE->initial_or_num);

    // Initiliaze root if necessary
    int l;
    GETV_D(l, root, th_length, thor_Directory);
    if (l == -1) { // Root has not been initialized
      (DISPATCH_N_D((thor_Directory)root, init__CiaDO_, thor_Directory))(root);
    }

    FE->root = root;

    if (argc == 2 && strcmp(argv[1],"calendar") == 0)
      calendar_main(root);
    else
      java_main(root);
}



