#include "compiler/C/extern.h"

#include "compiler/C++wrappers/core.h"
#include "compiler/C++wrappers/fields.h"

#include "cache1/resident_object_table.h"
#include "cache1/trace_replacer.h"

#include "fe/main/fe_config.h"

// Counter with the number of object accesses
unsigned long Access_counter = 0; 

// 
// IMPORTANT:
// Execution tracing assumes all accesses are to objects from OR 1.
//
// void Execution_trace(struct Fields_s *v)
//   Effects: Trace access to "v" and store trace in  FE->trace_file.
//   Requires: "v" is the fields of a valid object and 
//     FE->trace_file is open for reading. 
//
// Trace file format:
//   The trace has a tuple <id, last_access> for each run "r" of
//   consecutive accesses to a page "id" for which the access number
//   of the last access in "r" is "last_access".
//   "id" and last_access are of type Uint. These fields are stored 
//   in little endian.
//
void Execution_trace(struct Fields_s *v) {
  static Uint prev_page_id = 0;   // All the accesses in previous 
                                  // run were for prev_page_id
  Fields f = (Fields) v;
  Oref o = f->to_core()->oref();
  Uint page_id = Oref_page(o);
  
  if (o && page_id != prev_page_id) {
    // If object is persistent and this is first access to a new
    // persistent page...
    Trace_entry t;
    t.page_id = prev_page_id; t.last_access = Access_counter;
    fwrite(&t, sizeof(Trace_entry), 1, FE->trace_file);
    prev_page_id = page_id;
  }
  Access_counter++;
}

