#include "fe_send_message.h"
#include "common/transaction.h"
#include "utils/network.h"

FE_send_fetch_msg::FE_send_fetch_msg(Oref oref_, Seg_bmap prefetch_bmap_,
				     bool alloc_request_):
    oref(oref_), prefetch_bmap(prefetch_bmap_), alloc_request(alloc_request_)
{}

bool FE_send_fetch_msg::encode(Network* net) {
    return Oref_encode(oref, net) &&
	prefetch_bmap.encode(net) &&
	net->send_ubits32(Ubits32(alloc_request), TRUE) &&
	net->flush();
}

bool FE_send_commit_msg::encode(Network* net) {
    // Send the commit message
    if (! (net->send_ubits32(is_coord, TRUE) && trans->encode(net))) {
	perror("Commit message failed");
	return FALSE;
    }
    return net->flush();
}

bool FE_send_invalid_ack_msg::encode(Network *net) {
    // No need to flush the network
    return (net->send_ubits32(last_message_seen, FALSE));
}

bool FE_send_debug_msg::encode(Network *net) {
    if (!net->send_ubits32(debug_type))  return FALSE;
    int num = data.size();
    if (!net->send_ubits32(num)) return FALSE;
    return net->send_buffer(data.as_pointer(), num * sizeof(int))
	&& net->flush();
}
