#include "fe_send_message.h"
#include "or_recv_message.h"
#include "stats.h"

#include "fe/main/fe_config.h"

#include "common/or_address.h"
#include "common/fe_message.h"

#include "utils/communication.h"

FE_stats *fe_stats;

bool Get_or_stats(OR_num or_num, OR_stat& stat) {

    FE_send_trigger_msg send_msg(FE_trigger_stats);
    OR_recv_stat_reply_msg recv_msg(&stat);
    Ubits32 id = 0;

    FE->comm->send(OR_address(or_num), &send_msg, &recv_msg, id);
    // Block waiting for stats reply.
    if (FE->comm->handle_messages_until_done(id) < 1)
	return FALSE;
    return TRUE;
}
