#include "tm.h"
#include "or_recv_message.h"

#include "fe/main/fe_config.h"

#include "common/oref.h"
#include "common/locator.h"

#include "utils/basic.h"
#include "utils/bits.h"
#include "utils/network.h"

bool OR_recv_commit_reply_msg::decode(Network *net, Ubits32) {
    Ubits32 reply;
    bool success = net->recv_ubits32(&reply);
    if (!success) {
	perror("Commit reply not received");
    }
    commit = commit && reply == OR_committed;
    num_received++;
    return TRUE;
}

bool OR_recv_commit_reply_msg::skip(Network* net) {
    Ubits32 dummy;
    bool success = net->recv_ubits32(&dummy);
    return success;
}

bool OR_recv_invalidation_msg::decode(Network *net, Ubits32) {
    skip(net);
    // The orefs are now in the "orefs" array. start, end also have been set
    OR_num orx = OR_address(net->address).or_num();
    int num = orefs.size();
    th_assert(num, "Inv msg with 0 invalidations received");

    FE->tm->invalidate_objects(orx, orefs.as_pointer(), num, msg_start, 
			       msg_end, WAIT_OTHER);
    return TRUE;
}

bool OR_recv_invalidation_msg::skip(Network *net) {
    struct {Ubits32 count, msg_start, msg_end;} hdr;
    bool success = net->recv_buffer(&hdr, sizeof(hdr));
    if (!success) {
       perror("Invalidation message not received correctly");
       return FALSE;
    }

    msg_start  = hdr.msg_start;
    msg_end    = hdr.msg_end;
    orefs.clear();
    orefs._enlarge_by(hdr.count);
    if (!net->recv_buffer(orefs.as_pointer(), hdr.count * sizeof(Oref))) 
        perror("Invalidation message not received correctly");
    return TRUE;
}

bool OR_recv_alloc_reply_msg::decode(Network *net, Ubits32) {
    skip(net);
    // We now have the information about the allocation rights.
    OR_num orx = OR_address(net->address).or_num();
    OR_info *or_info = FE->or_map->lookup(orx);
    Seg_info *si = or_info->lookup_seg_info(segid);
    // Register allocation rights received for the segment.
    si->alloc_rights = si->alloc_rights | bmap;
    si->empty = empty_bmap;
    return TRUE;
}


bool OR_recv_alloc_reply_msg::skip(Network* net) {
    int bmap_bytes = (bmap.size() + byte_bits - 1)/byte_bits;
    if (!net->recv_ubits32(&segid) || !net->recv_buffer(&bmap, bmap_bytes)
	|| !net->recv_buffer(&empty_bmap, bmap_bytes)) {
	perror("Could not skip over the alloc reply message");
    }
    return TRUE;
}
