#include "compiler/C++wrappers/core.h"
#include "compiler/C++wrappers/class.h"

#include "unswizzle.h"

#include "cache1/surrogate_table.h"

#include "fe/main/fe_config.h"

#include "common/or_obj.h"
#include "common/oref.h"
#include "common/objrefs.h"

void unswizzle_object(Core c, OR_obj* or_obj, OR_num orx, bool install_header) {

    if (install_header) {
	Class_c cl(c->get_class());
	Xref class_xref = cl.class_xref();
	Oref class_oref = class_xref.oref;
	// XXX We need to see if this is the class_oref for this OR
	th_assert(!Oref_equal(class_oref, NULL_OREF), "Class oref not found");
	or_obj->set_class_oref(class_oref);
    }

    Object_references gen = Object_references(c->bitfields(), c->num_slots());
    int slotno;

    // Iterate through all the slots of the object and unswizzle them
    Obj_x *slots = (Obj_x *)or_obj->fields();
    while (gen.get(slotno)) {
	if (slots[slotno].is_data()) continue;
	// Swizzled pointer needs to be unswizzled
	Core target = (Core) slots[slotno].pointer();
	Xref target_xref = target->xref();
	th_assert(target->is_persistent(), "Unswizzling ref to volatile obj");
	Oref target_oref = target_xref.oref;
	if (target_xref.orx != orx) {
	    target_oref = FE->surr_table->lookup(target_xref.orx,
						 target_xref.oref, orx);
	    th_assert(!Oref_equal(target_oref, NULL_OREF),
		      "Target oref not found");
	}
	slots[slotno].store_data(target_oref);
    }
}
