//  ClassInstall.java -- for copying class files into a package directory

//  Copyright 1996, 1997 Arizona Board of Regents;
//  see COPYRIGHT file for details.



package toba;

import java.io.*;

public class ClassInstall {



public static void mkdir(String name) 
    throws IOException
{
    name = name.replace('/', File.separatorChar);
    File f = new File(name);
    if (!f.isDirectory() && !f.mkdirs())
	throw new IOException("Could not make directory " + name);
}

public static void copy(DataInputStream src, String destname) 
       throws IOException
{
    int len;
    byte[] buf = new byte[4096];

    destname = destname.replace('/', File.separatorChar);
    FileOutputStream dest = new FileOutputStream(destname);
    while (true) {
	len = src.read(buf);
	if (len <= 0)
	    break;
	dest.write(buf, 0, len);
    }
}

public static void install(String findname, String classname, String target)
    throws IOException, ClassNotFoundException
{
    target = target + "/";

    // Get a handle for reading the class file
    ClassFile f = ClassFile.find(findname);

    // turn class name into a filename
    String filename = classname.replace('.', '/') + ".class";

    // copy it into place
    int index = filename.lastIndexOf('/');
    if (index > 0) {
	String dir = filename.substring(0, index);
	mkdir(target + dir);
    }
    copy(f, target + filename);
    f.close();
}


} // class ClassInstall
