//  DataFile.java -- methods for writing .pth files

package toba;

import java.io.*;
import java.util.*;

class DataFile {

static private Hashtable declared;	// set of class structs declared

static private Hashtable ivtable;	// table of visible instance variables
static private int hvnum;		// hidden variable number

static private boolean first_var = true;


//  write(d, c) -- write header info for class c on stream d.

static void write(PrintWriter d, ClassData c)
{
    d.println();
    d.println("#ifndef " + c.cname + "_DATA");
    d.println("#define " + c.cname + "_DATA");
    d.println();
    d.print(c.cname);
    d.print("\t" + c.cname + "_V");
    d.print("\tWK_" + c.cname + "_OREF");
    d.print("\tInit_" + c.cname);

    d.println();
    d.print(c.cname + "_static");
    d.print("\t" + c.cname + "_static" + "_V");
    d.print("\tWK_" + c.cname + "_static" + "_OREF");
    d.print("\tInit_" + c.cname);

    d.println();
    d.println("#endif /* " + c.cname + "_DATA */");
}

} // class DataFile
