//  InsGen.java -- generation of C code for bytecode instructions

//  Copyright 1996, 1997 Arizona Board of Regents;
//  see COPYRIGHT file for details.



package toba;

import java.io.*;



class InsGen extends Opcode {



  //  igen(d, m, ins) -- generate code for one instruction

  static void igen(PrintWriter d, Method m, Instr ins)
    {
      int n;
      Ref r;
      String s, t1, t2;
	
      Opcode o = ins.opcode;
	
      switch (o.kind) {

      case NOP:			// nop, pop, pop2, breakpoint
	// nothing 
	break;

      case ACONST:			// aconst_null
	d.println("/*CONST, ins.val=" + ins.val + "=o.var=" + o.var + "*/");
	d.println(assign(ins) + "JAVA_NULL;");
	break;

      case CONST:			// bipush, fconst_<n>, ...
	d.println(assign(ins) + (ins.val + o.var) + ";");
	break;

      case LDC:			// ldc, ldc_2, ldc2_w
	d.println(assign(ins) + Repr.con(m, ins.con) + ";");
	break;

      case LOAD:			// iload, aload_<n>, fload, ...
	d.println(assign(ins) + o.name.substring(0, 1) + "v" +
		  (ins.val + o.var) + ";");
	break;

      case STORE:			// istore, fstore_<n>, astore, ...
	s = stacktop(ins);
	d.println("\t" + s.substring(0, 1) + "v" + (ins.val + o.var) +
		  " = " + s + ";");
	break;

      case IINC:			// iinc
	d.println("\tiv" + ins.val + " += " + ins.more[0] + ";");
	break;

      case GETS:			// getstatic
      case PUTS:			// putstatic
	r = (Ref)ins.con.value;
	s = Names.hashclass(r.classname);
	{
	  String obj_class = s + "_static";

	  // ZZZ: Jul 3: Removed for now
	  // if not in this class or a superclass
	  // if (!ancestor(m.cl, s))	
	  //  d.println("\tinit_" + s + "();");

	  d.println("\t{");

	  // obj_class obj = GET_STATIC_OBJ(obj_class);
	  d.println("\t\t" + obj_class + " obj = GET_STATIC_OBJ(" + obj_class + ");");

	  // struct obj_class_f_s *Fp_ = RESIDENT_CORE(obj, obj_class);
	  d.print("\t\tstruct " + obj_class + "_f_s " + "*Fp_ = ");
	  d.println("RESIDENT_CORE(obj, " + obj_class + ");");
		  
	  if (o.kind == GETS) {
	    String tgt_var = stacktop_after(ins);
	    String src_var = "th_" + Names.hashvar(r.name);

	    // PREPARE_READ_F(obj, Fp_);
	    d.println("\t\tPREPARE_READ_F(obj, Fp_ );");
		  
	    if ((r.signature.charAt(0) == '[')  // Array type
		|| (r.signature.charAt(0) == 'L')) { // Object type
	      String field_class = Repr.ctype_actual(r.signature);

	      // GETP_F(tgt_var, Fp_, scr_var, obj_class, field_class);
	      d.print("\t\tGETP_F(" + tgt_var + ", Fp_, " + src_var);
	      d.println(", " + obj_class + ", " + field_class + ");");

	    } else { // Basic type
	      // GETV_F(tgt_var, Fp_, scr_var, obj_class);
	      d.print("\t\tGETV_F(" + tgt_var + ", Fp_, " + src_var);
	      d.println(", " + obj_class + ");");
	    }

	  } else { // (o.kind == PUTS)
	    String src_var = stacktop(ins);
	    String tgt_var = "th_" + Names.hashvar(r.name);

	    // PREPARE_WRITE_F(obj, Fp_);
	    d.println("\t\tPREPARE_WRITE_F(obj, Fp_);");
		  
	    if ((r.signature.charAt(0) == '[')  // Array type
		|| (r.signature.charAt(0) == 'L')) { // Object type
	      // PREPARE_PWRITE_F(Fp_);
	      d.println("\t\tPREPARE_PWRITE_F(Fp_);");

	      // PUTP_F(Fp_, tgt_var, scr_var, obj_class);
	      d.print("\t\tPUTP_F(Fp_, " + tgt_var + ", " + src_var);
	      d.println(", " + obj_class + ");"); 

	    } else { // Basic type
	      // PUTV_F(Fp_, tgt_var, scr_var, obj_class);
	      d.print("\t\tPUTV_F(Fp_, " + tgt_var + ", " + src_var);
	      d.println(", " + obj_class + ");");
	    }
	  }

	  d.println("\t}");
	}
	break;

      case GETF:			// getfield
	checkref(d, ins, -1);
	r = (Ref)ins.con.value;
	{ // Thor: 
	  String src_var = "th_" + Names.hashvar(r.name);
	  String tgt_var = stacktop_after(ins);
	  String obj = stacktop(ins);
	  String obj_class = Names.hashclass(r.classname);

	  d.println("\t{");

	  // struct obj_class_f_s *Fp_ = RESIDENT_CORE(obj, obj_class);
	  d.print("\t\tstruct " + obj_class + "_f_s " + "*Fp_ = ");
	  d.println("RESIDENT_CORE(" + obj + ", " + obj_class + ");");
		  
	  // PREPARE_READ_F(obj, Fp_);
	  d.println("\t\tPREPARE_READ_F(" + obj + ", Fp_ );");
		  
	  // Thor : Get field.
	  // ZZZ: Is treating array types as reference types okay here?  
	  if ((r.signature.charAt(0) == '[')  // Array type
	      || (r.signature.charAt(0) == 'L')) { // Object type
	    String field_class = Repr.ctype_actual(r.signature);

	    // GETP_F(tgt_var, Fp_, scr_var, obj_class, field_class);
	    d.print("\t\tGETP_F(" + tgt_var + ", Fp_, " + src_var);
	    d.println(", " + obj_class + ", " + field_class + ");");

	  } else { // Basic type
	    // GETV_F(tgt_var, Fp_, scr_var, obj_class);
	    d.print("\t\tGETV_F(" + tgt_var + ", Fp_, " + src_var);
	    d.println(", " + obj_class + ");");
	  }
	  d.println("\t}");
	}
	break;

      case PUTF:			// putfield
	checkref(d, ins, -2);
	r = (Ref)ins.con.value;
	{ // Thor: 
	  String src_var = stacktop(ins);
	  String tgt_var = "th_" + Names.hashvar(r.name);
	  String obj = stack2nd(ins);
	  String obj_class = Names.hashclass(r.classname);
		  
	  d.println("\t{");
		  
	  // struct obj_class_f_s *Fp_ = RESIDENT_CORE(obj, obj_class);
	  d.print("\t\tstruct " + obj_class + "_f_s " + "*Fp_ = ");
	  d.println("RESIDENT_CORE(" + obj + ", " + obj_class + ");");
		  
	  // PREPARE_WRITE_F(obj, Fp_);
	  d.println("\t\tPREPARE_WRITE_F(" + obj + ", Fp_);");
		  
	  // Thor : Put field
	  // ZZZ: Is treating array types as reference types okay here?  
	  if ((r.signature.charAt(0) == '[')  // Array type
	      || (r.signature.charAt(0) == 'L')) { // Object type
	    // PREPARE_PWRITE_F(Fp_);
	    d.println("\t\tPREPARE_PWRITE_F(Fp_);");

	    // PUTP_F(Fp_, tgt_var, scr_var, obj_class);
	    d.print("\t\tPUTP_F(Fp_, " + tgt_var + ", " + src_var);
	    d.println(", " + obj_class + ");"); 

	  } else { // Basic type
	    // PUTV_F(Fp_, tgt_var, scr_var, obj_class);
	    d.print("\t\tPUTV_F(Fp_, " + tgt_var + ", " + src_var);
	    d.println(", " + obj_class + ");");
	  }

	  d.println("\t}");
	}
	break;

      case NEW:			// new
	{
	  String tgt_var = stacktop_after(ins);
	  String new_class = Names.hashclass((String)ins.con.value);
	      
	  d.println("\tALLOC_OBJ(" + tgt_var + ", " + new_class + ");");
	}
	break;

      case ACAST:			// checkcast
	d.println("\t{");
	// *** sidchang 12/5/00 ***
	// changed cast check from != 0 to != JAVA_NULL
	d.println("\t\tif ((" + stacktop(ins) + " != JAVA_NULL) && !" +
		  ckinstance(m, ins, (String)ins.con.value) +
		  ")\n\t\t\tthrowClassCastException(" + stacktop(ins) +");");
	d.println("\t}");
	break;

      case INSTC:			// instanceof
	d.println("\t{");
	// *** Chandra 12/5/00 ***
	// changed from != 0 to != JAVA_NULL
	d.println("\t" + assign(ins) + "(" + stacktop(ins) + " != JAVA_NULL) && " +
		  ckinstance(m, ins, (String)ins.con.value) + ";");
	d.println("\t}");
	break;

      case NEWA:			// newarray
	{
	  String tgt_var = stacktop_after(ins);
	  String length = stacktop(ins);
	  String type;
	  switch (ins.val) {
	  case T_BOOLEAN: type = "Boolean";	break;
	  case T_CHAR:  type = "Char"; 	break;
	  case T_FLOAT:	type = "Float";	break;
	  case T_DOUBLE:type = "Double";	break;
	  case T_BYTE:	type = "Byte"; 	break;
	  case T_SHORT:	type = "Short";	break;
	  case T_INT:  	type = "Int";  	break;
	  case T_LONG:	type = "Long"; 	break;
	  default:	throw new VerifyError
			  ("newarray(" + ins.val + ") at pc=" + ins.pc);
	  }
	  if (m.cl.arrays.get(type) == null)
	    m.cl.arrays.put(type, new Integer(1));

	  // ALLOC_ARRAY_V_I(tgt_var, type, length, 0);
	  d.print("\tALLOC_ARRAY_V_I(" + tgt_var + ", " + type);
	  d.println(", " + length + ", 0);");
	}
	break;

      case ANEWA:			// anewarray
	{
	  String tgt_var = stacktop_after(ins);
	  String length = stacktop(ins);
	  String type = (String)ins.con.value;

	  for (n=0; type.charAt(n) == '['; n++)
	    ;
          if (n>0) {
	      type = Repr.ctype_actual(type.substring(n)); 
	  } else {
	      type = Names.hashclass(type.substring(n)); 
	  }
	  int nDim = n+1;

	  Integer dim;
	  if (((dim = (Integer) m.cl.arrays.get(type)) == null) 
	      || (nDim > dim.intValue()))
	    m.cl.arrays.put(type, new Integer(nDim));

	  // ALLOC_ARRAY_P_I(tgt_var, type, length, nDim, JAVA_NULL);
	  d.print("\tALLOC_ARRAY_P_I(" + tgt_var + ", " + type);
	  d.println(", " + length + ", " + nDim + ", JAVA_NULL);");
	}
	break;

      case MNEWA:			// multianewarray
	// Trans.abort("***: multianewarray not yet implemented");
	{
	  String tgt_var = stacktop_after(ins);
	  String type = (String)ins.con.value;

	  for (n = 0; type.charAt(n) == '['; n++)
	    ;                       // n = class dimensions
	  char c = type.charAt(n);

	  type = Repr.ctype_actual(type.substring(n));
	  int nDim = n;

	  Integer dim;
	  if (((dim = (Integer) m.cl.arrays.get(type)) == null) 
	      || (nDim > dim.intValue()))
	    m.cl.arrays.put(type, new Integer(nDim));

	  d.print(assign(ins));
	  int nArgs = ins.more[0];  // number of args

	  if (nDim > nArgs) c = 'L';

          // MNewArray(Array_V, c, nDim, nArgs, length1,length2,...)
	  d.print("MNewArray(self_P->");
	  d.print(type + "_Array_" + nDim + "_V, ");
	  d.print("\'" + c + "\'" + ", " + nDim + ", " + nArgs); 

	  for (int i = 0; i < nArgs; i++) {
	    d.print(",i" + (ins.after.length() + i));
	  }
	  d.println(");");
	}
	break;

      case ALEN:			// arraylength
	{
	  String obj = stacktop(ins);
	  String tgt_var = stacktop_after(ins);

	  checkref(d, ins, -1);
	  d.println("\t{");

	  // struct Array_f_s *Fp_ = RESIDENT_CORE(obj, Array);
	  d.print("\t\tstruct Array_f_s *Fp_ = ");
	  d.println("RESIDENT_CORE(" + obj + ", Array);");
		  
	  // PREPARE_READ_F(obj, Fp_);
	  d.println("\t\tPREPARE_READ_F(" + obj + ", Fp_ );");
		  
	  // GETV_F(tgt_var, Fp_, length, Array);
	  d.println("\t\tGETV_F(" + tgt_var + ", Fp_, length, Array);");

	  d.println("\t}");
	}
	break;

      case ALOAD:			// iaload, faload, aaload,...
	checkref(d, ins, -2);
	{ 
	  char c = o.name.charAt(0);	// i,f,a,...

	  String type = Repr.ctype_field_slots(o.name);
	  if (type.equals("Object")) type = "Shortp";

	  String index = stacktop(ins);
	  String obj = stack2nd(ins);
	  String tgt_var = stacktop_after(ins);
	  String tmp_var = "length";

	  d.println("\t{");

	  // UInt tmp_var;
	  d.println("\t\tUInt " + tmp_var + ";");

	  // struct type_Array_f_s *Fp_ = RESIDENT_CORE(obj, type_Array);
	  d.print("\t\tstruct " + type + "_Array_f_s *Fp_ = ");
	  d.println("RESIDENT_CORE(" + obj + ", " + type + "_Array);");
		  
	  // PREPARE_READ_F(obj, Fp_);
	  d.println("\t\tPREPARE_READ_F(" + obj + ", Fp_ );");
		  
	  // GETV_F(tmp_var, Fp_, length, type_Array);
	  d.println("\t\tGETV_F(" + tmp_var + ", Fp_, length, " + type + "_Array);");

	  // if ((UInt) index >= tmp_var) throw ...
	  d.println("\t\tif ((UInt) " + index + ">= " + tmp_var + ")");
	  d.println("\t\t\tTHROW(java_lang_NullPointerException);"); // TTT: ArrayIndexOOB

	  // GETA[PV]_F(tgt_var, Fp_, index, type);
	  if (c == 'a') {
	    d.print("\t\tGETAP_F");
	  } else {
	    d.print("\t\tGETAV_F");
	  }
	  d.println("(" + tgt_var + ", Fp_, " + index + ", " + type + ");");

	  d.println("\t}");
	}
	break;

      case ASTOR:			// iastore, fastore, aastore,...
	checkref(d, ins, -3);	
	{ 
	  char c = o.name.charAt(0);	// i,f,a,...

	  String type = Repr.ctype_field_slots(o.name);
	  if (type.equals("Object")) type = "Shortp";

	  String index = stack2nd(ins);
	  String obj = stackvar(ins, -3);
	  String src_var = stacktop(ins);
	  String tmp_var = "length";

	  d.println("\t{");

	  // UInt tmp_var;
	  d.println("\t\tUInt " + tmp_var + ";");

	  // struct type_Array_f_s *Fp_ = RESIDENT_CORE(obj, type_Array);
	  d.print("\t\tstruct " + type + "_Array_f_s *Fp_ = ");
	  d.println("RESIDENT_CORE(" + obj + ", " + type + "_Array);");
		  
	  // PREPARE_READ_F(obj, Fp_);
	  d.println("\t\tPREPARE_READ_F(" + obj + ", Fp_ );");
		  
	  // GETV_F(tmp_var, Fp_, length, type_Array);
	  d.println("\t\tGETV_F(" + tmp_var + ", Fp_, length, " + type + "_Array);");

	  // if ((UInt) index >= tmp_var) throw ...
	  d.println("\t\tif ((UInt) " + index + " >= " + tmp_var + ")");
	  d.println("\t\t\tTHROW(java_lang_NullPointerException);"); // TTT: ArrayIndexOOB

	  // PREPARE_WRITE_F(obj, Fp_);
	  d.println("\t\tPREPARE_WRITE_F(" + obj + ", Fp_);");
		  
	  // PUTA[PV]_F(Fp_, index, src_var, type);
	  if (c == 'a') {
	    // PREPARE_PWRITE_F(Fp_);
	    d.println("\t\tPREPARE_PWRITE_F(Fp_);");
	    d.print("\t\tPUTAP_F");
	  } else {
	    d.print("\t\tPUTAV_F");
	  }
	  d.println("(Fp_, " + index + ", " + src_var + ", " + type + ");");

	  d.println("\t}");

	}
	break;

      case DUP:			// dup
	d.println(assign(ins) + stacktop(ins) + ";");
	break;

      case DUPX1:			// dup_x1
	// for dup_x1 to be legal, stacktop and stack2nd must be narrow vars
	d.println("\t" + stackvar(ins.succ,-1) +" = "+ stacktop(ins) +";");
	d.println("\t" + stackvar(ins.succ,-2) +" = "+ stack2nd(ins) +";");
	d.println("\t"+stackvar(ins.succ,-3)+" = "+stacktop(ins.succ)+";");
	break;

      case DUPX2:			// dup_x2
	// stacktop must be narrow, but stack2nd may be wide
	d.println("\t" + stackAt(ins.succ,-1) +" = "+ stackAt(ins,-1) +";");
	d.println("\t" + stackAt(ins.succ,-2) +" = "+ stackAt(ins,-2) +";");
	if (ins.before.charAt(ins.before.length() - 3) != 'x') { 
	  // stack2nd was narrow
	  d.println("\t" + stackAt(ins.succ,-3) + " = " + 
		    stackAt(ins,-3) + ";");
	}
	d.println("\t"+stackAt(ins.succ,-4)+" = "+ stackAt(ins.succ,-1)+";");
	break;

      case DUP2:			// dup2
	// stacktop can be wide or narrow; dup 2 words either way
	d.println(assign(ins) + stacktop(ins) + ";");
	if (ins.before.charAt(ins.before.length() - 2) != 'x') {
	  // stacktop was narrow variable; duping two separate values
	  d.println("\t"+stack2nd(ins.succ)+" = "+ stack2nd(ins)+";");
	}
	break;

      case D2X1:			// dup2x1
	// stacktop can be wide or narrow; stackAt(ins,-3) is narrow
	d.println(assign(ins) + stacktop(ins) + ";");
	d.println("\t"+stackAt(ins.succ,-3)+" = "+stackAt(ins,-3)+";");
	if (ins.before.charAt(ins.before.length() - 2) != 'x') {
	  // stacktop contains a narrow variable
	  d.println("\t" + stackAt(ins.succ,-2) + " = " +
		    stackAt(ins,-2) + ";");
	  d.println("\t" + stackAt(ins.succ,-5) + " = " + 
		    stackAt(ins.succ,-2) + ";");
	}
	d.println("\t"+stackAt(ins.succ,-4)+" = "+stackAt(ins.succ,-1)+";");
	break;

      case D2X2:			// dup2x2
	d.println("\t"+stackAt(ins.succ,-1)+" = "+stackAt(ins,-1)+";");
	if (ins.before.charAt(ins.before.length() - 2) != 'x')
	  d.println("\t"+stackAt(ins.succ,-2)+" = "+stackAt(ins,-2)+";");
	d.println("\t"+stackAt(ins.succ,-3)+" = "+stackAt(ins,-3)+";");
	if (ins.before.charAt(ins.before.length() - 4) != 'x')
	  d.println("\t"+stackAt(ins.succ,-4)+" = "+stackAt(ins,-4)+";");
	d.println("\t"+stackAt(ins.succ,-5)+" = "+stackAt(ins.succ,-1)+";");
	if (ins.before.charAt(ins.before.length() - 2) != 'x')
	  d.println("\t"+stackAt(ins.succ,-6)+" = "+stackAt(ins.succ,-2)+
		    ";");
	break;

      case SWAP:			// swap
	n = ins.before.length();
	t1 = ins.before.substring(n - 1);
	t2 = ins.before.substring(n - 2, n - 1);
	d.println("\t" + t1 + "0 = " + t1 + n + ";");
	d.println("\t" + t2 + n + " = " + t2 + (n-1) + ";");
	d.println("\t" + t1 + (n-1) + " = " + t1 + "0;");
	break;

      case UNOP:			// ineg, f2d, int2short, ...
	d.println(assign(ins) + o.opr + stacktop(ins) + ";");
	break;

      case FTOI:			// float-to-int conversion (incl d, l)
	d.println(assign(ins) + o.opr + "(" + stacktop(ins) + ");");
	break;

      case DIVOP:			// {i,l}{div,rem}, but not {f,d}
	d.println("\tif (!" + stacktop(ins) +
		  ") throwDivisionByZeroException();"); 
	// no break
      case BINOP:			// iadd, fsub, dmul, ...
	d.println(assign(ins) + stack2nd(ins) +o.opr+ stacktop(ins) + ";");
	break;

      case FREM:			// frem, drem
	d.println(assign(ins) +
		  "remdr(" + stack2nd(ins) + "," + stacktop(ins) + ");");
	break;

      case SHIFT:			// ishl, iushr, lshr, ...
	s = "";				// assume no cast
	if (o.push.length() == 2) {
	  n = 0x3F;			// mask 6 bits for long shifts
	  if ((o.flags & UNS) != 0)
	    s = "(ULong)";
	} else {
	  n = 0x1F;			// mask 5 bits for int shifts
	  if ((o.flags & UNS) != 0)
	    s = "(UInt)";
	}
	d.println(assign(ins) + s + stack2nd(ins) + o.opr +
		  "(" + stacktop(ins) + " & " + n + ");");
	break;

      case CMP:			// lcmp, fcmpl, dcmpg, ...
	// these are carefully crafted to make NaN cases come out right
	if (o.var < 0)			// if want -1 for NaN
	  d.println(assign(ins) + "(" +
		    stack2nd(ins) + " > " + stacktop(ins) + ") ? 1 : ((" +
		    stack2nd(ins) + " == " + stacktop(ins) + ") ? 0 : -1);");
	else
	  d.println(assign(ins) + "(" +
		    stack2nd(ins) + " < " + stacktop(ins) + ") ? -1 : ((" +
		    stack2nd(ins) + " == " + stacktop(ins) + ") ? 0 : 1);");
	break;

      case IFZRO:			// ifeq, ifnull, ifgt, ...
	// *** Chandra 12/4/00 ***
	// Changed 0 to JAVA_NULL if appropriate
	if ((stacktop(ins).charAt(0) == 'a') &&
	    (o.opr == " != ")) {
	  d.print("\tif (" + stacktop(ins) + o.opr + "JAVA_NULL)\n\t\t");
	} else if ((stacktop(ins).charAt(0) == 'a') &&
	    (o.opr == " == ")) {
	    // *** sidchang 12/5/00 ***
	    // Changed 0 to JAVA_NULL for case where o.opr is ==
	  d.print("\tif (" + stacktop(ins) + o.opr + "JAVA_NULL)\n\t\t");
	}
	else {
	  d.print("\tif (" + stacktop(ins) + o.opr + "0)\n\t\t");
	}
	gengoto(d, m, ins, ins.val);
	break;

      case IFCMP:			// if_icmplt, if_acmpne, ...
	d.print("\tif (" + stack2nd(ins) +o.opr +stacktop(ins) + ")\n\t\t");
	gengoto(d, m, ins, ins.val);
	break;

      case TBLSW:			// tableswitch
	n = ins.more[1] - 3;		// correction factor
	d.println("\tswitch (" + stacktop(ins) + ") {");
	for (int i = 3; i < ins.more.length; i++) {
	  d.print("\t\tcase " + (i + n) + ": \t");
	  gengoto(d, m, ins, ins.more[i]);
	}
	d.print("\t\tdefault:\t");
	gengoto(d, m, ins, ins.more[0]);
	d.println("\t}");
	break;

      case LKPSW:			// lookupswitch
	d.println("\tswitch (" + stacktop(ins) + ") {");
	for (int i = 2; i < ins.more.length; i += 2) {
	  d.print("\t\tcase " + ins.more[i] + ": \t");
	  gengoto(d, m, ins, ins.more[i + 1]);
	}
	d.print("\t\tdefault:\t");
	gengoto(d, m, ins, ins.more[0]);
	d.println("\t}");
	break;

      case GOTO:			// goto
	d.print("\t");
	gengoto(d, m, ins, ins.val);
	break;

      case JSR:			// jsr
	d.println("\ti" + (ins.before.length() + 1) + " = " + 
		  target(m, ins.pc + ins.length) + ";");
	d.println("\tgoto L" + target(m, ins.val) + ";");
	break;

      case RET:			// ret [to pc set by jsr]
	// to do without macro call:
	// d.println("\ttgt = iv" + ins.val + ";");
	// d.println("\tgoto TOP;");
	d.println("\tRETTO(" + ins.pc + ",iv" + ins.val + ");");
	break;

      case IVIRT:			// invokevirtual
      case INONV:			// invokenonvirtual
	{
	  r = (Ref)ins.con.value;
	  n = argindex(ins, r.signature);
	  checkref(d, ins, n + 1);
		  
	  String obj = "" + ins.before.charAt(n) + (n + 1);
	  String obj_class = Names.hashclass(r.classname);
	  String method_name = Names.hashmethod(r.name, r.classname, r.signature);
	  String return_class = Repr.retType(r.signature);

	  if (o.kind == IVIRT) { //invoke virtual
	    // DISPATCH_V_D(obj, method_name, obj_class)
	    s = "DISPATCH_V_D(";
	    s = s.concat(obj + ", " + method_name + ", ");
	    s = s.concat(obj_class + ")");
	  } else {               // invokenonvirtual

	    // DISPATCH_N_D(obj, method_name, obj_class)
	    s = "DISPATCH_N_D(";
	    s = s.concat(obj + ", " + method_name + "_, ");
	    s = s.concat(obj_class + ")");
	  }

	  invoke(d, ins, r, s);
	}
	break;

      case ISTAT:			// invokestatic
	{
	  r = (Ref)ins.con.value;
	  String obj_class = Names.hashclass(r.classname);
	  String method_name = Names.hashmethod(r.name, r.classname, r.signature);
	  s = "DISPATCH_S(" + method_name + ", "+ obj_class + ")";
	  invoke(d, ins, r, s);
	}
	break;

      case IINTR:			// invokeinterface
	{
	  r = (Ref)ins.con.value;
	  n = argindex(ins, r.signature);
	  checkref(d, ins, n + 1);

	  String hashCode = "" + Names.hashinterface(r.name, r.signature);
	  String return_class = Repr.retType(r.signature);
	  String obj = "a" + (n+1);

	  // ((return_class (*)(selfClass, argTypes ...)) DISPATCH_I_D)
	  // (obj, hashCode)
	  s = "((" + return_class + " (*)(";
	  String sig = "(L" + r.classname + ";";
	  sig = sig.concat(r.signature.substring(1));
	  s = s.concat(Repr.argTypes(sig) + ")) ");

	  s = s.concat("DISPATCH_I_D(" + obj + ", " + hashCode + "))");

	  invoke(d, ins, r, s);
	}
	break;

      case RETV:			// ireturn, areturn, ...
	if (MethGen.needSwitch(m)) {
	  d.println("\trv = " + stacktop(ins) + ";");
	  d.println("\tgoto RETURN;");
	} else
	  d.println("\treturn " + stacktop(ins) + ";");
	break;

      case RETRN:			// return
	if (MethGen.needSwitch(m))
	  d.println("\tgoto RETURN;");
	else
	  d.println("\treturn;");
	break;
	
      case THROW:			// athrow
	if (m.handlers.length > 0) {	// if local handler
	  d.println("\ttdata->exception = " + stacktop(ins) + ";");
	  d.println("\tgoto CATCH;");
	} else {
	  d.println("\tThrow(" + stacktop(ins) + ");");
	}
	break;

      case MENTR:			// monitorenter
	// monitorenter(tos, thread, curpc + 1, &pc)
	d.println("\tmonitorenter(" + stacktop(ins) + 
		  ", tdata, " + (ins.pc + 1) + ", &pc);");
	break;

      case MEXIT:			// monitorexit
	// monitorexit(tos, thread, curpc, &pc)
	d.println("\tmonitorexit(" + stacktop(ins) + 
		  ", tdata, " + (ins.pc + 1) + ", &pc);");
	break;

      default:
	throw new VerifyError
	  ("unimplemented opcode " + o.name + " at pc=" + ins.pc);
      }
    }



  //  ancestor(cl, h) -- is the hashed classname h our class or a superclass? 

  static private boolean ancestor(ClassData cl, String s)
    {
      for (; cl != null; cl = cl.superclass)
	if (s.equals(cl.cname))
	  return true;
      return false;
    }



  //  gengoto(d, m, ins, pc) -- generate goto from ins to pc

  static private void gengoto(PrintWriter d, Method m, Instr ins, int pc)
    {
      int lbl = target(m, pc);

      //    to do without macro calls:
      //    d.println("goto L" + lbl + ";");

      if (ins.pc > pc)
	d.println("GOBACK(" + ins.pc + ",L" + lbl + ");");
      else
	d.println("GOTO(" + ins.pc + ",L" + lbl + ");");
    }



  //  target(m, pc) -- return label corresponding to jump target given in pc terms

  static private int target(Method m, int pc)
    {
      return m.instrs[m.pcmap[pc]].label;
    }




  //  checkref(d, ins, n) -- gen code to check that stack variable n is non-null
  //
  //  If n >= 0, the variable name is  "a" + n;
  //  If n < 0, the variable name is   stackvar(ins,n);

  static private void checkref(PrintWriter d, Instr ins, int n)
    {
      String s;

      if (n >= 0)
	s = "a" + n;
      else
	s = stackvar(ins, n);

      d.println("\tif (" + s + " == JAVA_NULL) goto NULLX;");
      MethGen.nullJump = true;		// set flag in method generator
    }



  //  ckinstance(ins, classname) -- return code that checks "instance of" relation
  //
  //  Let S be the type of the (non-null) object on top of the stack.
  //  Let T be the target type indicated in the instruction.
  //
  //  The conditions under which S is an instance of T, or S is castable to T,
  //  depend on type T.
  //
  //  If T is java.lang.Object:	always true, even if S is an array
  //  If T is a class:		true if S is T or a subclass of T
  //				(always true of T is java.lang.Object)
  //				or if S implements T
  //  If T is array of primitive:	true if S is same class as T
  //				(array of same primitive type)
  //  If T is array of object TC:	true if S is array of object SC and
  //				SC is instance of TC

  static private String ckinstance(Method m, Instr ins, String classname)
    {
      // handle special case of java.lang.Object
      if (classname.equals("java.lang.Object"))
	return "1";

      String obj = stacktop(ins);
      String c;

      int n;
      for (n = 0; classname.charAt(n) == '['; n++)
	;					// n = class dimensions
      if (n==0) 
	c = Names.hashclass(classname);
      else 
	c = Repr.ctype_actual(classname.substring(n));

      if (n==0) {
	return "INSTANCE_OF(" + obj + ", " + c + ")";
      } else {
	if (m.cl.arrays.get(c) == null)
	  m.cl.arrays.put(c, new Integer(n));
	return "ARRAY_INSTANCE_OF(" + obj + ", " + c + ", " + n + ")";
      }
    }



  //  invoke(d, ins, r, cname) -- generate code to invoke cname

  static private void invoke(PrintWriter d, Instr ins, Ref r, String cname)
    {
      int i = argindex(ins, r.signature);

      // start with result assignment, if any, and function name
      if (i == ins.after.length())	// if no result pushed
	d.print("\t");
      else
	d.print(assign(ins));

      // add name or expression that identifies the function
      d.print(cname + "(");

      // generate argument list
      int nArgs = 0;

      if (ins.opcode.kind == ISTAT) {
	nArgs++;
	String obj_class = Names.hashclass(r.classname) + "_static";
	d.print("GET_STATIC_OBJ(" + obj_class + ")");
      }

      for (; i < ins.before.length(); i++) {
	if (ins.before.charAt(i) != 'x') {
	  if (nArgs++ != 0)
	    d.print(" ,");
	  d.print(ins.before.substring(i, i+1) + (i + 1));
	}
      }
      d.println(");");
    }



  //  argindex(ins, signature) -- return index of first arg of method call

  static private int argindex(Instr ins, String signature)
    {
      char c = signature.charAt(signature.indexOf(')') + 1);	// return type
      int n = ins.after.length();		// stack size after call

      if (c == 'J' || c == 'D')
	return n - 2;			// long or double returns add two words
      else if (c == 'V')
	return n;			// no compensation for void return
      else
	return n - 1;			// other return types add one word
    }



  //  assign(ins) -- return beginning of assignment stmt ("\tvarname = ").

  static final String assign(Instr ins)
    {
      return "\t" + ins.after.substring(ins.after.length() - 1)
+ ins.after.length() + " = ";
    }


  //  stacktop(ins) -- return name of top-of-stack variable.

  static final String stacktop(Instr ins)
    {
      return ins.before.substring(ins.before.length() - 1) + ins.before.length();
    }

  //  stacktop_after(ins) -- return top-of-stack variable after the instruction

  static final String stacktop_after(Instr ins)
    {
      return ins.after.substring(ins.after.length() - 1) + ins.after.length();
    }


  //  stack2nd(ins) -- return name of second-from-top stack variable.

  static final String stack2nd(Instr ins)
    {
      int len = ins.before.length();
      if (ins.before.charAt(len - 2) == 'x')	// if double-sized item on top
	return ins.before.substring(len - 3, len - 2) + (len - 2);
      else
	return ins.before.substring(len - 2, len - 1) + (len - 1);
    }


  //  stackvar(ins, n) -- return name of stack var at n (-1 = top, -2 = 2nd, etc.)
  //
  //  n counts actual stack variables, not stack positions 

  static final String stackvar(Instr ins, int n)
    {
      int i = ins.before.length();
      while (n < 0)
	if (ins.before.charAt(--i) != 'x')
	  n++;
      return ins.before.substring(i, i + 1) + (i + 1);
    }


  //  stackAt(ins, n) -- return name of stack var at position n (-1, -2, -3)
  //
  //  n reflects position on stack without regard to double-wide variables

  static final String stackAt(Instr ins, int n)
    {
      int i = ins.before.length() + n;
      return ins.before.substring(i, i + 1) + (i + 1);
    }

} // class InsGen

