//  Lister.java -- list classes from same location as java/lang/String.class.

//  Copyright 1996, 1997 Arizona Board of Regents;
//  see COPYRIGHT file for details.


package toba;

import java.io.*;
import java.util.*;
import java.util.zip.*;

public class Lister {



private static void printname(String name) 
{
    try {
	// strip off ".class" and change file separators to '.'
	name = name.substring(0, name.length() - 6);
	name = name.replace(File.separatorChar, '.');
	name = name.replace('/', '.');
	System.out.println(name);
    } catch(StringIndexOutOfBoundsException e) {
    }
}

// recursively descend directory adding entries to hash table
private static void recursivelist(String prefix, String dir) {
    File f = new File(dir, prefix);
    String[] files = f.list();
    if (files == null)
	return;
    for (int i = 0; i < files.length; i++) {
	String name = prefix + files[i];
	File file = new File(dir, name);
	if (f.isDirectory())
	    recursivelist(name + File.separator, dir);
	if (name.endsWith(".class")) {
	    printname(name);
	}
    }
}

// print out all system classes from the same location as java/lang/String
public static void listSystemClasses() {
    String aSystemClassFile = "java/lang/String.class";
    aSystemClassFile.replace('/', File.separatorChar);

    // walk the class path until we see a java directory
    //YYY +File.pathSeparator is necessary for otherwise the last path 
    //YYY   component is never searched
    String classpath = System.getProperty("java.class.path")+File.pathSeparator;
    int i, j;
    for (i = 0; (j = classpath.indexOf(File.pathSeparator, i)) >= 0; 
	    i = j + 1) {
	String dir = classpath.substring(i, j);
	if (dir.endsWith(".zip")) {
	    // look through .zip
	    try {
		ZipFile zf = new ZipFile(dir);
		ZipEntry zfe = zf.getEntry(aSystemClassFile);
		if (zfe == null) {
		    zf.close();
		    continue;
		}

		// we found a system class, this is the one we want
		Enumeration files = zf.entries();
		while (files.hasMoreElements()) {
		    zfe = (ZipEntry)files.nextElement();
		    String name = zfe.getName();
		    if (name.endsWith(".class"))
			printname(name);
		}
		zf.close();
		return;
	    } catch(IOException e) {
	    }
	} else {
	    // look through directory
	    File f = new File(dir + File.separatorChar + aSystemClassFile);
	    if (!f.exists())        
		continue;

	    // we found a system class, this is the one we want
	    recursivelist("", dir);
	    return;
	}
    }

    System.err.println("No System Classes Found (is CLASSPATH set?)!");
    System.exit(1);
}

public static void main(String[] args) {
    listSystemClasses();
}



} // class Lister
