// Copyright 1995 Barbara Liskov

/*
\section{Coordinator set} 

The TM maintains a set of ORs that have been coordinators in the
recent past.  This set is used in Stamos' optimization, which allows
participants to avoid forcing the log in phase 1 of the commit
protocol.

Concurrent access is protected by a mutex.

*/

#ifndef _COORD_SET_H
#define _COORD_SET_H

#include "utils/basic.h"
#include "utils/array.h"
#include "common/or_num.h"

class OR_set;
class Tstamp;
class Mutex;

struct CoordEntry {
    OR_num or_num;      // Coordinator's OR number
    Tstamp tstamp;      // Timestamp of last transaction with coordinator
};

declareArray(CoordArray, CoordEntry *)

class Coord_set {
public:
    Coord_set();

    ~Coord_set();

    bool member(OR_num coord);
    // effects  - Return true iff given OR is in set.

    void add(OR_num coord, Tstamp t);
    // effects  - If coordinator not present in set, add it with given
    //            timestamp.  Otherwise, update timestamp of existent
    //            entry.

    void truncate(Tstamp t, OR_set *ors);
    // effects -  Remove all coordinators whose timestamps are less
    //            than t.  Adds names of coordinators to given set.

private:
    CoordArray *set;
    Mutex *mutex;

    int find(OR_num or_num);
    // requires - Caller holds mutex.
    // effects  - Returns index of entry with given OR number, or -1 if
    //            not present.

};

#endif /* _COORD_SET_H */
